import {OrganizationalUnitPersonRole} from "@admin/models/organizational-unit-person-role.model";
import {PersonRole} from "@admin/models/person-role.model";
import {Injectable} from "@angular/core";
import {preservationSpaceOrganizationalUnitPersonRoleActionNameSpace} from "@app/features/preservation-space/organizational-unit/stores/person-role/preservation-space-organizational-unit-person-role.action";
import {ApiResourceNameEnum} from "@app/shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {environment} from "@environments/environment";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {
  ApiService,
  defaultRelation3TiersStateInitValue,
  NotificationService,
  QueryParameters,
  Relation3TiersForm,
  Relation3TiersState,
  Relation3TiersStateModel,
} from "solidify-frontend";

export interface PreservationSpaceOrganizationalUnitPersonRoleStateModel extends Relation3TiersStateModel<PersonRole> {
}

@Injectable()
@State<PreservationSpaceOrganizationalUnitPersonRoleStateModel>({
  name: LocalStateEnum.preservationSpace_organizationalUnit_personRole,
  defaults: {
    ...defaultRelation3TiersStateInitValue(),
    queryParameters: new QueryParameters(environment.maximalPageSizeToRetrievePaginationInfo),
  },
})
// OrganizationalUnitPersonController
export class PreservationSpaceOrganizationalUnitPersonRoleState extends Relation3TiersState<PreservationSpaceOrganizationalUnitPersonRoleStateModel, PersonRole, OrganizationalUnitPersonRole> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: preservationSpaceOrganizationalUnitPersonRoleActionNameSpace,
      resourceName: ApiResourceNameEnum.PERSON,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.organizationalUnits;
  }

  protected convertResourceInForm(resource: PersonRole): Relation3TiersForm {
    return {id: resource.resId, listId: resource.roles.map(r => r.resId)};
  }
}
