import {Injectable} from "@angular/core";
import {Institution} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {preservationSpaceOrganizationalUnitInstitutionNamespace} from "@preservation-space/organizational-unit/stores/institution/preservation-space-organizational-unit-institution.action";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  ApiService,
  AssociationState,
  AssociationStateModel,
  defaultAssociationStateInitValue,
  NotificationService,
} from "solidify-frontend";

export interface PreservationSpaceOrganizationalUnitInstitutionStateModel extends AssociationStateModel<Institution> {
}

@Injectable()
@State<PreservationSpaceOrganizationalUnitInstitutionStateModel>({
  name: LocalStateEnum.preservationSpace_organizationalUnit_institution,
  defaults: {
    ...defaultAssociationStateInitValue(),
  },
})
export class PreservationSpaceOrganizationalUnitInstitutionState extends AssociationState<PreservationSpaceOrganizationalUnitInstitutionStateModel, Institution> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: preservationSpaceOrganizationalUnitInstitutionNamespace,
      resourceName: ApiResourceNameEnum.INSTITUTION,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.organizationalUnits;
  }
}
