import {Injectable} from "@angular/core";
import {ArchiveACL} from "@models";
import {
  Actions,
  Selector,
  State,
  Store,
} from "@ngxs/store";
import {preservationSpaceOrganizationalUnitArchiveAclActionNameSpace} from "@preservation-space/organizational-unit/stores/archive-acl/preservation-space-organizational-unit-archive-acl.action";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  ApiService,
  defaultResourceStateInitValue,
  isNullOrUndefined,
  MARK_AS_TRANSLATABLE,
  NotificationService,
  ResourceState,
  ResourceStateModel,
  StoreUtil,
} from "solidify-frontend";

export interface PreservationSpaceOrganizationalUnitArchiveAclStateModel extends ResourceStateModel<ArchiveACL> {
}

@Injectable()
@State<PreservationSpaceOrganizationalUnitArchiveAclStateModel>({
  name: LocalStateEnum.preservationSpace_organizationalUnit_archiveAcl,
  defaults: {
    ...defaultResourceStateInitValue(),
  },
  children: [],
})
export class PreservationSpaceOrganizationalUnitArchiveAclState extends ResourceState<PreservationSpaceOrganizationalUnitArchiveAclStateModel, ArchiveACL> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: preservationSpaceOrganizationalUnitArchiveAclActionNameSpace,
      notificationResourceCreateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.archive-acl.notification.resource.create"),
      notificationResourceDeleteSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.archive-acl.notification.resource.delete"),
      notificationResourceUpdateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.archive-acl.notification.resource.update"),
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.archiveAcl;
  }

  @Selector()
  static isLoading(state: PreservationSpaceOrganizationalUnitArchiveAclStateModel): boolean {
    return StoreUtil.isLoadingState(state);
  }

  @Selector()
  static isLoadingWithDependency(state: PreservationSpaceOrganizationalUnitArchiveAclStateModel): boolean {
    return this.isLoading(state);
  }

  @Selector()
  static currentTitle(state: PreservationSpaceOrganizationalUnitArchiveAclStateModel): string | undefined {
    if (isNullOrUndefined(state.current)) {
      return undefined;
    }
    return state.current.user.firstName + " " + state.current.user.lastName;
  }

  @Selector()
  static isReadyToBeDisplayed(state: PreservationSpaceOrganizationalUnitArchiveAclStateModel): boolean {
    return this.isReadyToBeDisplayedInCreateMode
      && !isNullOrUndefined(state.current);
  }

  @Selector()
  static isReadyToBeDisplayedInCreateMode(state: PreservationSpaceOrganizationalUnitArchiveAclStateModel): boolean {
    return true;
  }
}
