import {NgModule} from "@angular/core";
import {PreservationSpaceOrganizationalUnitRoutingModule} from "@app/features/preservation-space/organizational-unit/preservation-space-organizational-unit-routing.module";
import {PreservationSpaceOrganizationalUnitPersonRoleState} from "@app/features/preservation-space/organizational-unit/stores/person-role/preservation-space-organizational-unit-person-role.state";
import {PreservationSpaceOrganizationalUnitState} from "@app/features/preservation-space/organizational-unit/stores/preservation-space-organizational-unit.state";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {PreservationSpaceOrganizationalUnitRequestCreationDialog} from "@preservation-space/organizational-unit/components/dialogs/organizational-unit-request-creation/preservation-space-organizational-unit-request-creation.dialog";
import {PreservationSpaceOrganizationalUnitArchiveAclFormPresentational} from "@preservation-space/organizational-unit/components/presentationals/organizational-unit-archive-acl-form/preservation-space-organizational-unit-archive-acl-form.presentational";
import {PreservationSpaceOrganizationalUnitFormPresentational} from "@preservation-space/organizational-unit/components/presentationals/organizational-unit-form/preservation-space-organizational-unit-form.presentational";
import {PreservationSpaceOrganizationalUnitArchiveAclCreateRoutable} from "@preservation-space/organizational-unit/components/routables/organizational-unit-archive-acl-create/preservation-space-organizational-unit-archive-acl-create.routable";
import {PreservationSpaceOrganizationalUnitArchiveAclDetailEditRoutable} from "@preservation-space/organizational-unit/components/routables/organizational-unit-archive-acl-detail-edit/preservation-space-organizational-unit-archive-acl-detail-edit.routable";
import {PreservationSpaceOrganizationalUnitArchiveAclListRoutable} from "@preservation-space/organizational-unit/components/routables/organizational-unit-archive-acl-list/preservation-space-organizational-unit-archive-acl-list.routable";
import {PreservationSpaceOrganizationalUnitDetailEditRoutable} from "@preservation-space/organizational-unit/components/routables/organizational-unit-detail-edit/preservation-space-organizational-unit-detail-edit.routable";
import {PreservationSpaceOrganizationalUnitListRoutable} from "@preservation-space/organizational-unit/components/routables/organizational-unit-list/preservation-space-organizational-unit-list.routable";
import {PreservationSpaceOrganizationalUnitArchiveAclState} from "@preservation-space/organizational-unit/stores/archive-acl/preservation-space-organizational-unit-archive-acl.state";
import {PreservationSpaceOrganizationalUnitInstitutionState} from "@preservation-space/organizational-unit/stores/institution/preservation-space-organizational-unit-institution.state";
import {ModuleLoadedEnum} from "@shared/enums/module-loaded.enum";
import {SharedModule} from "@shared/shared.module";
import {PreservationSpaceOrganizationalUnitRequestAccessDialog} from "./components/dialogs/organizational-unit-request-access/preservation-space-organizational-unit-request-access.dialog";

const routables = [
  PreservationSpaceOrganizationalUnitDetailEditRoutable,
  PreservationSpaceOrganizationalUnitListRoutable,
  PreservationSpaceOrganizationalUnitArchiveAclListRoutable,
  PreservationSpaceOrganizationalUnitArchiveAclDetailEditRoutable,
  PreservationSpaceOrganizationalUnitArchiveAclCreateRoutable,
];
const containers = [];
const dialogs = [
  PreservationSpaceOrganizationalUnitRequestAccessDialog,
  PreservationSpaceOrganizationalUnitRequestCreationDialog,
];
const presentationals = [
  PreservationSpaceOrganizationalUnitFormPresentational,
  PreservationSpaceOrganizationalUnitArchiveAclFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    PreservationSpaceOrganizationalUnitRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      PreservationSpaceOrganizationalUnitState,
      PreservationSpaceOrganizationalUnitPersonRoleState,
      PreservationSpaceOrganizationalUnitArchiveAclState,
      PreservationSpaceOrganizationalUnitInstitutionState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class PreservationSpaceOrganizationalUnitModule {
  constructor() {
    window[ModuleLoadedEnum.preservationSpaceOrganizationalUnitModuleLoaded] = true;
  }
}
