import {NgModule} from "@angular/core";
import {RouterModule} from "@angular/router";
import {Enums} from "@enums";
import {PreservationSpaceOrganizationalUnitArchiveAclCreateRoutable} from "@preservation-space/organizational-unit/components/routables/organizational-unit-archive-acl-create/preservation-space-organizational-unit-archive-acl-create.routable";
import {PreservationSpaceOrganizationalUnitArchiveAclDetailEditRoutable} from "@preservation-space/organizational-unit/components/routables/organizational-unit-archive-acl-detail-edit/preservation-space-organizational-unit-archive-acl-detail-edit.routable";
import {PreservationSpaceOrganizationalUnitArchiveAclListRoutable} from "@preservation-space/organizational-unit/components/routables/organizational-unit-archive-acl-list/preservation-space-organizational-unit-archive-acl-list.routable";
import {PreservationSpaceOrganizationalUnitDetailEditRoutable} from "@preservation-space/organizational-unit/components/routables/organizational-unit-detail-edit/preservation-space-organizational-unit-detail-edit.routable";
import {PreservationSpaceOrganizationalUnitListRoutable} from "@preservation-space/organizational-unit/components/routables/organizational-unit-list/preservation-space-organizational-unit-list.routable";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
  PreservationSpaceOrganizationalUnitRoutesEnum,
} from "@shared/enums/routes.enum";
import {OrganizationalUnitComputeIsManagerGuardService} from "@shared/guards/organizational-unit-compute-is-manager.service";
import {OrganizationalUnitRoleGuardService} from "@shared/guards/organizational-unit-role-guard.service";
import {DlcmRoutes} from "@shared/models/dlcm-route.model";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";
import {PreservationSpaceOrganizationalUnitState} from "./stores/preservation-space-organizational-unit.state";

const routes: DlcmRoutes = [
  {
    path: "",
    component: PreservationSpaceOrganizationalUnitListRoutable,
    data: {},
  },
  {
    path: PreservationSpaceOrganizationalUnitRoutesEnum.detail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: PreservationSpaceOrganizationalUnitDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: PreservationSpaceOrganizationalUnitState.currentTitle,
    },
    canActivate: [OrganizationalUnitComputeIsManagerGuardService],
    children: [
      {
        path: PreservationSpaceOrganizationalUnitRoutesEnum.edit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
          orgUnitPermissionNeed: [Enums.Role.RoleEnum.MANAGER],
        },
        canActivate: [OrganizationalUnitRoleGuardService],
        canDeactivate: [CanDeactivateGuard],
      },
      {
        path: PreservationSpaceOrganizationalUnitRoutesEnum.manageAcl,
        data: {
          breadcrumb: LabelTranslateEnum.archiveAcl,
          orgUnitPermissionNeed: [Enums.Role.RoleEnum.STEWARD, Enums.Role.RoleEnum.MANAGER],
        },
        canActivate: [OrganizationalUnitRoleGuardService],
        children: [
          {
            path: "",
            component: PreservationSpaceOrganizationalUnitArchiveAclListRoutable,
          },
          {
            path: PreservationSpaceOrganizationalUnitRoutesEnum.manageAclDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
            component: PreservationSpaceOrganizationalUnitArchiveAclDetailEditRoutable,
            data: {
              // breadcrumb: LabelTranslateEnum.archiveAcl,
            },
            children: [
              {
                path: AdminRoutesEnum.archiveAclEdit,
                data: {
                  breadcrumb: LabelTranslateEnum.edit,
                },
                canDeactivate: [CanDeactivateGuard],
              },
            ],
          },
          {
            component: PreservationSpaceOrganizationalUnitArchiveAclCreateRoutable,
            path: PreservationSpaceOrganizationalUnitRoutesEnum.manageAclCreate,
            data: {
              breadcrumb: LabelTranslateEnum.create,
            },
            canDeactivate: [CanDeactivateGuard],
          },
        ],
      },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class PreservationSpaceOrganizationalUnitRoutingModule {
}
