import {PersonRole} from "@admin/models/person-role.model";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnInit,
  ViewChild,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {
  ActivatedRoute,
  RouterOutlet,
} from "@angular/router";
import {PreservationSpaceOrganizationalUnitPersonRoleState} from "@app/features/preservation-space/organizational-unit/stores/person-role/preservation-space-organizational-unit-person-role.state";
import {preservationSpaceOrganizationalUnitActionNameSpace} from "@app/features/preservation-space/organizational-unit/stores/preservation-space-organizational-unit.action";
import {
  PreservationSpaceOrganizationalUnitState,
  PreservationSpaceOrganizationalUnitStateModel,
} from "@app/features/preservation-space/organizational-unit/stores/preservation-space-organizational-unit.state";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {AppState} from "@app/stores/app.state";
import {AppUserState} from "@app/stores/user/app-user.state";
import {Enums} from "@enums";
import {HomeHelper} from "@home/helpers/home.helper";
import {
  DisseminationPolicy,
  Institution,
  OrganizationalUnit,
  PreservationPolicy,
  Role,
  SubmissionPolicy,
} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {
  OrgunitRequestAccessDialogResult,
  PreservationSpaceOrganizationalUnitRequestAccessDialog,
} from "@preservation-space/organizational-unit/components/dialogs/organizational-unit-request-access/preservation-space-organizational-unit-request-access.dialog";
import {PreservationSpaceOrganizationalUnitDisseminationPolicyAction} from "@preservation-space/organizational-unit/stores/dissemination-policy/preservation-space-organizational-unit-dissemination-policy.action";
import {PreservationSpaceOrganizationalUnitDisseminationPolicyState} from "@preservation-space/organizational-unit/stores/dissemination-policy/preservation-space-organizational-unit-dissemination-policy.state";
import {PreservationSpaceOrganizationalUnitInstitutionAction} from "@preservation-space/organizational-unit/stores/institution/preservation-space-organizational-unit-institution.action";
import {PreservationSpaceOrganizationalUnitInstitutionState} from "@preservation-space/organizational-unit/stores/institution/preservation-space-organizational-unit-institution.state";
import {PreservationSpaceOrganizationalUnitPreservationPolicyAction} from "@preservation-space/organizational-unit/stores/preservation-policy/preservation-space-organizational-unit-preservation-policy.action";
import {PreservationSpaceOrganizationalUnitPreservationPolicyState} from "@preservation-space/organizational-unit/stores/preservation-policy/preservation-space-organizational-unit-preservation-policy.state";
import {PreservationSpaceOrganizationalUnitSubmissionPolicyAction} from "@preservation-space/organizational-unit/stores/submission-policy/preservation-space-organizational-unit-submission-policy.action";
import {PreservationSpaceOrganizationalUnitSubmissionPolicyState} from "@preservation-space/organizational-unit/stores/submission-policy/preservation-space-organizational-unit-submission-policy.state";
import {SharedAbstractDetailEditCommonRoutable} from "@shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable";
import {PreservationSpaceOrganizationalUnitRoutesEnum} from "@shared/enums/routes.enum";
import {ScrollService} from "@shared/services/scroll.service";
import {SecurityService} from "@shared/services/security.service";
import {SharedDisseminationPolicyState} from "@shared/stores/dissemination-policy/shared-dissemination-policy.state";
import {SharedNotificationAction} from "@shared/stores/notification/shared-notification.action";
import {sharedOrganizationalUnitActionNameSpace} from "@shared/stores/organizational-unit/shared-organizational-unit.action";
import {SharedPreservationPolicyState} from "@shared/stores/preservation-policy/shared-preservation-policy.state";
import {SharedResearchDomainAction} from "@shared/stores/research-domain/shared-research-domain.action";
import {SharedResearchDomainState} from "@shared/stores/research-domain/shared-research-domain.state";
import {SharedRoleState} from "@shared/stores/role/shared-role.state";
import {SharedSubmissionPolicyState} from "@shared/stores/submission-policy/shared-submission-policy.state";
import {Observable} from "rxjs";
import {
  distinctUntilChanged,
  tap,
} from "rxjs/operators";
import {
  isNullOrUndefined,
  MappingObject,
  MemoizedUtil,
  OverrideProperty,
  ResourceNameSpace,
  StringUtil,
} from "solidify-frontend";

@Component({
  selector: "dlcm-preservation-space-organizational-unit-detail-edit-routable",
  templateUrl: "./preservation-space-organizational-unit-detail-edit.routable.html",
  styleUrls: ["./preservation-space-organizational-unit-detail-edit.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PreservationSpaceOrganizationalUnitDetailEditRoutable extends SharedAbstractDetailEditCommonRoutable<OrganizationalUnit, PreservationSpaceOrganizationalUnitStateModel> implements OnInit {
  @Select(PreservationSpaceOrganizationalUnitState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(PreservationSpaceOrganizationalUnitState.isReadyToBeDisplayed) isReadyToBeDisplayedObs: Observable<boolean>;
  currentUserIsManager: Observable<boolean> = MemoizedUtil.select(this._store, PreservationSpaceOrganizationalUnitState, state => state.currentUserIsManager);
  listSubmissionPoliciesObs: Observable<SubmissionPolicy[]> = MemoizedUtil.list(this._store, SharedSubmissionPolicyState);
  listPreservationPoliciesObs: Observable<PreservationPolicy[]> = MemoizedUtil.list(this._store, SharedPreservationPolicyState);
  listDisseminationPoliciesObs: Observable<DisseminationPolicy[]> = MemoizedUtil.list(this._store, SharedDisseminationPolicyState);
  listRoleObs: Observable<Role[]> = MemoizedUtil.list(this._store, SharedRoleState);
  selectedPersonRoleObs: Observable<PersonRole[]> = MemoizedUtil.selected(this._store, PreservationSpaceOrganizationalUnitPersonRoleState);
  selectedInstitutionObs: Observable<Institution[]> = MemoizedUtil.selected(this._store, PreservationSpaceOrganizationalUnitInstitutionState);
  researchDomainSourcesObs: Observable<string[]> = MemoizedUtil.select(this._store, SharedResearchDomainState, state => state.sources);
  selectedSubmissionPoliciesObs: Observable<SubmissionPolicy[]> = MemoizedUtil.selected(this._store, PreservationSpaceOrganizationalUnitSubmissionPolicyState);
  selectedPreservationPoliciesObs: Observable<PreservationPolicy[]> = MemoizedUtil.selected(this._store, PreservationSpaceOrganizationalUnitPreservationPolicyState);
  selectedDisseminationPoliciesObs: Observable<DisseminationPolicy[]> = MemoizedUtil.selected(this._store, PreservationSpaceOrganizationalUnitDisseminationPolicyState);

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedOrganizationalUnitActionNameSpace;

  readonly KEY_PARAM_NAME: keyof OrganizationalUnit & string = "name";

  @OverrideProperty()
  readonly deleteAvailable: boolean = false;

  isManageAcl: boolean = false;

  isTour: boolean = false;

  @ViewChild(RouterOutlet) outlet: RouterOutlet;

  constructor(protected _store: Store,
              protected _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _securityService: SecurityService,
              public _dialog: MatDialog,
              private readonly _scrollService: ScrollService) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.preservationSpace_organizationalUnit, preservationSpaceOrganizationalUnitActionNameSpace, LocalStateEnum.preservationSpace);
  }

  ngOnInit(): void {
    if (MemoizedUtil.selectSnapshot(this._store, AppState, state => state.isInTourMode)) {
      this.isTour = true;
      return;
    }

    super.ngOnInit();

    this._store.dispatch(new SharedResearchDomainAction.GetSource());

    this.subscribe(this.urlStateObs
      .pipe(
        distinctUntilChanged(),
        tap(urlState => {
          if (urlState) {
            const url = urlState.url;
            this.isManageAcl = url.includes(PreservationSpaceOrganizationalUnitRoutesEnum.manageAcl);
            this._changeDetector.detectChanges();
            this._scrollService.scrollToTop(true);
          }
        }),
      ));
  }

  getSubResourceWithParentId(id: string): void {
    if (this._securityService.isManagerOfOrgUnit(id)) {
      this._store.dispatch(new PreservationSpaceOrganizationalUnitSubmissionPolicyAction.GetAll(id));
      this._store.dispatch(new PreservationSpaceOrganizationalUnitPreservationPolicyAction.GetAll(id));
      this._store.dispatch(new PreservationSpaceOrganizationalUnitDisseminationPolicyAction.GetAll(id));
      this._store.dispatch(new PreservationSpaceOrganizationalUnitInstitutionAction.GetAll(id));

    }
  }

  requestToBeMember(): void {
    this.subscribe(this._dialog.open(PreservationSpaceOrganizationalUnitRequestAccessDialog, {
      minWidth: "500px",
    }).afterClosed().pipe(
      tap((result: OrgunitRequestAccessDialogResult | undefined) => {
        if (isNullOrUndefined(result)) {
          return;
        }
        this.sendRequestToBeMember(result);
      }),
    ));
  }

  private sendRequestToBeMember(result: OrgunitRequestAccessDialogResult): void {
    this._store.dispatch(new SharedNotificationAction.Create({
      model: {
        emitter: MemoizedUtil.currentSnapshot(this._store, AppUserState),
        notifiedOrgUnit: {
          resId: this._resId,
        },
        objectId: result.roleId,
        message: result.message,
        notificationType: {
          resId: Enums.Notification.TypeEnum.JOIN_ORGUNIT_REQUEST,
        },
      },
    }));
  }

  seeArchive(orgUnit: OrganizationalUnit): void {
    HomeHelper.navigateToSearch(this._store, StringUtil.stringEmpty, {[Enums.Facet.Name.ORGANIZATIONAL_UNITS]: [orgUnit.name]} as MappingObject<string[]>);
  }
}
