import {AdminArchiveAclStateModel} from "@admin/archive-acl/stores/admin-archive-acl.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnInit,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {ArchiveACL} from "@models";
import {Navigate} from "@ngxs/router-plugin";
import {
  Actions,
  ofActionCompleted,
  Select,
  Store,
} from "@ngxs/store";
import {preservationSpaceOrganizationalUnitArchiveAclActionNameSpace} from "@preservation-space/organizational-unit/stores/archive-acl/preservation-space-organizational-unit-archive-acl.action";
import {PreservationSpaceOrganizationalUnitArchiveAclState} from "@preservation-space/organizational-unit/stores/archive-acl/preservation-space-organizational-unit-archive-acl.state";
import {SharedAbstractDetailEditCommonRoutable} from "@shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  AppRoutesEnum,
  PreservationSpaceOrganizationalUnitRoutesEnum,
  RoutesEnum,
} from "@shared/enums/routes.enum";
import {LocalStateModel} from "@shared/models/local-state.model";
import {SharedArchiveAclAction} from "@shared/stores/archive-acl/shared-archive-acl.action";
import {SharedArchiveAclState} from "@shared/stores/archive-acl/shared-archive-acl.state";
import {Observable} from "rxjs";
import {
  filter,
  take,
  tap,
} from "rxjs/operators";
import {
  isNullOrUndefined,
  isTrue,
  MemoizedUtil,
  ModelFormControlEvent,
  Override,
} from "solidify-frontend";

@Component({
  selector: "dlcm-preservation-space-organizational-unit-acl-detail-edit-routable",
  templateUrl: "./preservation-space-organizational-unit-archive-acl-detail-edit.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PreservationSpaceOrganizationalUnitArchiveAclDetailEditRoutable extends SharedAbstractDetailEditCommonRoutable<ArchiveACL, AdminArchiveAclStateModel> implements OnInit {
  isLoadingWithDependencyObs: Observable<boolean> = MemoizedUtil.isLoading(this._store, SharedArchiveAclState);
  @Select(PreservationSpaceOrganizationalUnitArchiveAclState.isReadyToBeDisplayed) isReadyToBeDisplayedObs: Observable<boolean>;
  orgUnitId: string;

  currentObs: Observable<ArchiveACL> = MemoizedUtil.current(this._store, PreservationSpaceOrganizationalUnitArchiveAclState).pipe(
    tap(current => this.current = current),
  );

  readonly KEY_PARAM_NAME: keyof ArchiveACL & string = "aipId";

  constructor(protected _store: Store,
              protected _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              public _dialog: MatDialog) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.preservationSpace_organizationalUnit_archiveAcl, preservationSpaceOrganizationalUnitArchiveAclActionNameSpace as any, LocalStateEnum.preservationSpace_organizationalUnit);
  }

  ngOnInit(): void {
    this.retrieveResIdFromUrl();
    super.ngOnInit();
  }

  protected getSubResourceWithParentId(id: string): void {
  }

  protected retrieveResIdFromUrl(): void {
    this._resId = this._route.snapshot.paramMap.get(AppRoutesEnum.paramIdWithoutPrefixParam);
    this.orgUnitId = this._route.snapshot.parent.parent.paramMap.get(AppRoutesEnum.paramIdWithoutPrefixParam);
  }

  @Override()
  edit(): void {
    if (this.isEdit) {
      return;
    }
    if (!this.editAvailable) {
      return;
    }
    this._store.dispatch(new Navigate([RoutesEnum.preservationSpaceOrganizationalUnitDetail, this.orgUnitId, PreservationSpaceOrganizationalUnitRoutesEnum.manageAcl, PreservationSpaceOrganizationalUnitRoutesEnum.manageAclDetail, this._resId, PreservationSpaceOrganizationalUnitRoutesEnum.manageAclEdit], {}, {skipLocationChange: true}));
  }

  @Override()
  update(modelFormControlEvent: ModelFormControlEvent<ArchiveACL>): Observable<any> {
    super.saveInProgress();

    this.subscribe(this._actions$.pipe(
      ofActionCompleted(SharedArchiveAclAction.UpdateSuccess),
      take(1),
      filter(result => isTrue(result.result.successful)),
      tap(result => {
        this.backToDetail();
        // return this._store.dispatch(new PreservationSpaceOrganizationalUnitArchiveAclAction.Update(this.orgUnitId, action.model));
      }),
    ));

    return this._store.dispatch(new SharedArchiveAclAction.Update(modelFormControlEvent));
  }

  @Override()
  protected cleanState(): void {
  }

  @Override()
  backToList(): void {
    this._store.dispatch(new Navigate([RoutesEnum.preservationSpaceOrganizationalUnitDetail, this.orgUnitId, PreservationSpaceOrganizationalUnitRoutesEnum.manageAcl]));
  }

  @Override()
  backToDetail(path: string[] = undefined): void {
    const currentUrl = this._store.selectSnapshot((s: LocalStateModel) => s.router.state.url);
    this.subscribe(this._store.dispatch(new Navigate(isNullOrUndefined(path) ? [RoutesEnum.preservationSpaceOrganizationalUnitDetail, this.orgUnitId, PreservationSpaceOrganizationalUnitRoutesEnum.manageAcl, PreservationSpaceOrganizationalUnitRoutesEnum.manageAclDetail, this._resId] : path))
      .pipe(
        tap((state: LocalStateModel) => {
          if (state.router.state.url !== currentUrl) {
            // this.formPresentational.resetFormToInitialValue();
            // TODO : Fix don't need to get by id model from backend but fix resetFormToInitialValue with component user role org unit
            // TODO : Problem currently if redirect to detail page via breadcrumb in case of Deposit
            this.retrieveCurrentModelWithUrl();
          }
        }),
      ));
  }

  @Override()
  delete(): void {
    super.delete();

    this.subscribe(this._actions$.pipe(
      ofActionCompleted(SharedArchiveAclAction.DeleteSuccess),
      take(1),
      filter(result => isTrue(result.result.successful)),
      tap(result => {
        this.backToList();
      }),
    ));
  }
}
