import {AdminArchiveAclStateModel} from "@admin/archive-acl/stores/admin-archive-acl.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnInit,
} from "@angular/core";
import {ActivatedRoute} from "@angular/router";
import {ArchiveACL} from "@models";
import {Navigate} from "@ngxs/router-plugin";
import {
  Actions,
  ofActionCompleted,
  Select,
  Store,
} from "@ngxs/store";
import {preservationSpaceOrganizationalUnitArchiveAclActionNameSpace} from "@preservation-space/organizational-unit/stores/archive-acl/preservation-space-organizational-unit-archive-acl.action";
import {PreservationSpaceOrganizationalUnitArchiveAclState} from "@preservation-space/organizational-unit/stores/archive-acl/preservation-space-organizational-unit-archive-acl.state";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  AppRoutesEnum,
  PreservationSpaceOrganizationalUnitRoutesEnum,
  RoutesEnum,
} from "@shared/enums/routes.enum";
import {UrlQueryParamHelper} from "@shared/helpers/url-query-param.helper";
import {SharedArchiveAclAction} from "@shared/stores/archive-acl/shared-archive-acl.action";
import {SharedArchiveAclState} from "@shared/stores/archive-acl/shared-archive-acl.state";
import {Observable} from "rxjs";
import {
  filter,
  take,
  tap,
} from "rxjs/operators";
import {
  isTrue,
  MemoizedUtil,
  ModelFormControlEvent,
  Override,
} from "solidify-frontend";

@Component({
  selector: "dlcm-apreservation-space-organizational-unit-acl-create-routable",
  templateUrl: "./preservation-space-organizational-unit-archive-acl-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PreservationSpaceOrganizationalUnitArchiveAclCreateRoutable extends SharedAbstractCreateRoutable<ArchiveACL, AdminArchiveAclStateModel> implements OnInit {
  isLoadingWithDependencyObs: Observable<boolean> = MemoizedUtil.isLoading(this._store, SharedArchiveAclState);
  @Select(PreservationSpaceOrganizationalUnitArchiveAclState.isReadyToBeDisplayedInCreateMode) isReadyToBeDisplayedInCreateModeObs: Observable<boolean>;
  orgUnitId: string;

  constructor(protected readonly _store: Store,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _route: ActivatedRoute) {
    super(_store, _actions$, _changeDetector, LocalStateEnum.preservationSpace_organizationalUnit_archiveAcl, preservationSpaceOrganizationalUnitArchiveAclActionNameSpace as any, LocalStateEnum.preservationSpace_organizationalUnit);
  }

  ngOnInit(): void {
    this.retrieveResIdFromUrl();
    this.urlQueryParameters = UrlQueryParamHelper.getQueryParamMappingObject();
  }

  protected retrieveResIdFromUrl(): void {
    this.orgUnitId = this._route.snapshot.parent.parent.paramMap.get(AppRoutesEnum.paramIdWithoutPrefixParam);
  }

  @Override()
  create(modelFormControlEvent: ModelFormControlEvent<ArchiveACL>): void {
    super.saveInProgress();

    this.subscribe(this._actions$.pipe(
      ofActionCompleted(SharedArchiveAclAction.CreateSuccess),
      take(1),
      filter(result => isTrue(result.result.successful)),
      tap(result => {
        const action: SharedArchiveAclAction.CreateSuccess = result.action;
        this._store.dispatch(new Navigate([RoutesEnum.preservationSpaceOrganizationalUnitDetail, this.orgUnitId, PreservationSpaceOrganizationalUnitRoutesEnum.manageAcl, PreservationSpaceOrganizationalUnitRoutesEnum.manageAclDetail, action.model.resId]));
        // this._store.dispatch(new PreservationSpaceOrganizationalUnitArchiveAclAction.Create(this.orgUnitId, action.model));
      }),
    ));

    this._store.dispatch(new SharedArchiveAclAction.Create(modelFormControlEvent));
  }

  @Override()
  backToList(): void {
    this._store.dispatch(new Navigate([RoutesEnum.preservationSpaceOrganizationalUnitDetail, this.orgUnitId, PreservationSpaceOrganizationalUnitRoutesEnum.manageAcl]));
  }

  @Override()
  protected cleanState(): void {
  }
}
