import {
  ChangeDetectionStrategy,
  Component,
  OnInit,
} from "@angular/core";
import {
  AbstractControl,
  FormBuilder,
  FormGroup,
  Validators,
} from "@angular/forms";
import {MatDialogRef} from "@angular/material/dialog";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SharedAbstractContainer} from "@shared/components/containers/shared-abstract/shared-abstract.container";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {SharedNotificationState} from "@shared/stores/notification/shared-notification.state";
import {SharedRoleAction} from "@shared/stores/role/shared-role.action";
import {Observable} from "rxjs";
import {
  FormValidationHelper,
  MemoizedUtil,
  PropertyName,
  SolidifyValidator,
} from "solidify-frontend";

@Component({
  selector: "dlcm-preservation-space-organizational-unit-request-creation-dialog",
  templateUrl: "./preservation-space-organizational-unit-request-creation.dialog.html",
  styleUrls: ["./preservation-space-organizational-unit-request-creation.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PreservationSpaceOrganizationalUnitRequestCreationDialog extends SharedAbstractContainer implements OnInit {
  isLoadingObs: Observable<boolean> = MemoizedUtil.isLoading(this._store, SharedNotificationState);

  form: FormGroup;
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  constructor(private readonly _store: Store,
              private readonly _actions$: Actions,
              private readonly _dialogRef: MatDialogRef<PreservationSpaceOrganizationalUnitRequestCreationDialog>,
              private readonly _fb: FormBuilder) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
    this._store.dispatch(new SharedRoleAction.GetAll());
    this.form = this._fb.group({
      [this.formDefinition.orgUnitName]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.message]: ["", [Validators.required, SolidifyValidator]],
    });
  }

  close(): void {
    this._dialogRef.close();
  }

  onSubmit(): void {
    this._dialogRef.close(this.form.value as OrgunitRequestCreationDialogResult);
  }

  getFormControl(key: string): AbstractControl {
    return FormValidationHelper.getFormControl(this.form, key);
  }

  get formValidationHelper(): typeof FormValidationHelper {
    return FormValidationHelper;
  }
}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() orgUnitName: string;
  @PropertyName() message: string;
}

export interface OrgunitRequestCreationDialogResult {
  orgUnitName: string;
  message: string;
}
