import {Injectable} from "@angular/core";
import {preservationSpaceNotificationStatusHistoryActionNameSpace} from "@app/features/preservation-space/notification/stores/status-history/preservation-space-notification-status-history.action";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {NotificationDlcm} from "@models";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {
  defaultStatusHistoryInitValue,
  StatusHistoryState,
  StatusHistoryStateModel,
} from "@shared/stores/status-history/status-history.state";
import {
  ApiService,
  NotificationService,
} from "solidify-frontend";

export interface PreservationSpaceNotificationStatusHistoryStateModel extends StatusHistoryStateModel<NotificationDlcm> {
}

@Injectable()
@State<PreservationSpaceNotificationStatusHistoryStateModel>({
  name: LocalStateEnum.preservationSpace_notification_statusHistory,
  defaults: {
    ...defaultStatusHistoryInitValue(),
  },
})
export class PreservationSpaceNotificationStatusHistoryState extends StatusHistoryState<PreservationSpaceNotificationStatusHistoryStateModel, NotificationDlcm> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: preservationSpaceNotificationStatusHistoryActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.notifications;
  }
}
