import {NotificationModeEnum} from "@app/features/preservation-space/notification/enums/notification-mode.enum";
import {Enums} from "@enums";
import {NotificationDlcm} from "@models";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {ViewModeEnum} from "@shared/enums/view-mode.enum";
import {
  BaseAction,
  BaseSubAction,
  ResourceAction,
  ResourceNameSpace,
  TypeDefaultAction,
} from "solidify-frontend";

const state = LocalStateEnum.preservationSpace_notification;

export namespace PreservationSpaceNotificationAction {
  @TypeDefaultAction(state)
  export class LoadResource extends ResourceAction.LoadResource {
  }

  @TypeDefaultAction(state)
  export class LoadResourceSuccess extends ResourceAction.LoadResourceSuccess {
  }

  @TypeDefaultAction(state)
  export class LoadResourceFail extends ResourceAction.LoadResourceFail {
  }

  @TypeDefaultAction(state)
  export class ChangeQueryParameters extends ResourceAction.ChangeQueryParameters {
  }

  @TypeDefaultAction(state)
  export class GetAll extends ResourceAction.GetAll {
  }

  @TypeDefaultAction(state)
  export class GetAllSuccess extends ResourceAction.GetAllSuccess<NotificationDlcm> {
  }

  @TypeDefaultAction(state)
  export class GetAllFail extends ResourceAction.GetAllFail<NotificationDlcm> {
  }

  @TypeDefaultAction(state)
  export class GetByListId extends ResourceAction.GetByListId {
  }

  @TypeDefaultAction(state)
  export class GetByListIdSuccess extends ResourceAction.GetByListIdSuccess {
  }

  @TypeDefaultAction(state)
  export class GetByListIdFail extends ResourceAction.GetByListIdFail {
  }

  @TypeDefaultAction(state)
  export class GetById extends ResourceAction.GetById {
  }

  @TypeDefaultAction(state)
  export class GetByIdSuccess extends ResourceAction.GetByIdSuccess<NotificationDlcm> {
  }

  @TypeDefaultAction(state)
  export class GetByIdFail extends ResourceAction.GetByIdFail<NotificationDlcm> {
  }

  @TypeDefaultAction(state)
  export class Create extends ResourceAction.Create<NotificationDlcm> {
  }

  @TypeDefaultAction(state)
  export class CreateSuccess extends ResourceAction.CreateSuccess<NotificationDlcm> {
  }

  @TypeDefaultAction(state)
  export class CreateFail extends ResourceAction.CreateFail<NotificationDlcm> {
  }

  @TypeDefaultAction(state)
  export class Update extends ResourceAction.Update<NotificationDlcm> {
  }

  @TypeDefaultAction(state)
  export class UpdateSuccess extends ResourceAction.UpdateSuccess<NotificationDlcm> {
  }

  @TypeDefaultAction(state)
  export class UpdateFail extends ResourceAction.UpdateFail<NotificationDlcm> {
  }

  @TypeDefaultAction(state)
  export class Delete extends ResourceAction.Delete {
  }

  @TypeDefaultAction(state)
  export class DeleteSuccess extends ResourceAction.DeleteSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteFail extends ResourceAction.DeleteFail {
  }

  @TypeDefaultAction(state)
  export class AddInList extends ResourceAction.AddInList<NotificationDlcm> {
  }

  @TypeDefaultAction(state)
  export class AddInListById extends ResourceAction.AddInListById {
  }

  @TypeDefaultAction(state)
  export class AddInListByIdSuccess extends ResourceAction.AddInListByIdSuccess<NotificationDlcm> {
  }

  @TypeDefaultAction(state)
  export class AddInListByIdFail extends ResourceAction.AddInListByIdFail<NotificationDlcm> {
  }

  @TypeDefaultAction(state)
  export class RemoveInListById extends ResourceAction.RemoveInListById {
  }

  @TypeDefaultAction(state)
  export class RemoveInListByListId extends ResourceAction.RemoveInListByListId {
  }

  @TypeDefaultAction(state)
  export class LoadNextChunkList extends ResourceAction.LoadNextChunkList {
  }

  @TypeDefaultAction(state)
  export class LoadNextChunkListSuccess extends ResourceAction.LoadNextChunkListSuccess<NotificationDlcm> {
  }

  @TypeDefaultAction(state)
  export class LoadNextChunkListFail extends ResourceAction.LoadNextChunkListFail {
  }

  @TypeDefaultAction(state)
  export class Clean extends ResourceAction.Clean {
  }

  export class SetMode {
    static readonly type: string = `[${state}] Set Mode`;

    constructor(public mode: NotificationModeEnum, public orgUnitId: string) {
    }
  }

  export class SetProcessed extends BaseAction {
    static readonly type: string = `[${state}] Set Processed`;

    constructor(public notificationId: string, public notificationCategory: Enums.Notification.CategoryEnum, public mode: ViewModeEnum) {
      super();
    }
  }

  export class SetProcessedSuccess extends BaseSubAction<SetProcessed> {
    static readonly type: string = `[${state}] Set Processed Success`;
  }

  export class SetProcessedFail extends BaseSubAction<SetProcessed> {
    static readonly type: string = `[${state}] Set Processed Fail`;
  }

  export class SetRefuse extends BaseAction {
    static readonly type: string = `[${state}] Set Refuse`;

    constructor(public notificationId: string, public notificationCategory: Enums.Notification.CategoryEnum, public mode: ViewModeEnum) {
      super();
    }
  }

  export class SetRefuseSuccess extends BaseSubAction<SetRefuse> {
    static readonly type: string = `[${state}] Set Refuse Success`;
  }

  export class SetRefuseFail extends BaseSubAction<SetRefuse> {
    static readonly type: string = `[${state}] Set Refuse Fail`;
  }

  export class SetPending extends BaseAction {
    static readonly type: string = `[${state}] Set Pending`;

    constructor(public notificationId: string, public notificationCategory: Enums.Notification.CategoryEnum, public mode: ViewModeEnum) {
      super();
    }
  }

  export class SetPendingSuccess extends BaseSubAction<SetPending> {
    static readonly type: string = `[${state}] Set Pending Success`;
  }

  export class SetPendingFail extends BaseSubAction<SetPending> {
    static readonly type: string = `[${state}] Set Pending Fail`;
  }
}

export const preservationSpaceNotificationActionNameSpace: ResourceNameSpace = PreservationSpaceNotificationAction;
