import {NgModule} from "@angular/core";
import {PreservationSpaceNotificationListRoutable} from "@app/features/preservation-space/notification/components/routables/preservation-space-notification-list/preservation-space-notification-list.routable";
import {PreservationSpaceNotificationStatusHistoryState} from "@app/features/preservation-space/notification/stores/status-history/preservation-space-notification-status-history.state";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {PreservationSpaceNotificationRoutingModule} from "@preservation-space/notification/preservation-space-notification-routing.module";
import {SharedModule} from "@shared/shared.module";
import {PreservationSpaceNotificationDetailEditRoutable} from "./components/routables/preservation-space-notification-detail-edit/preservation-space-notification-detail-edit.routable";
import {PreservationSpaceNotificationState} from "./stores/preservation-space-notification.state";

const routables = [
  PreservationSpaceNotificationListRoutable,
  PreservationSpaceNotificationDetailEditRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    PreservationSpaceNotificationRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      PreservationSpaceNotificationState,
      PreservationSpaceNotificationStatusHistoryState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class PreservationSpaceNotificationModule {
}
