import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {PreservationSpaceNotificationDetailEditRoutable} from "@app/features/preservation-space/notification/components/routables/preservation-space-notification-detail-edit/preservation-space-notification-detail-edit.routable";
import {PreservationSpaceNotificationListRoutable} from "@app/features/preservation-space/notification/components/routables/preservation-space-notification-list/preservation-space-notification-list.routable";
import {PreservationSpaceNotificationState} from "@app/features/preservation-space/notification/stores/preservation-space-notification.state";
import {
  AppRoutesEnum,
  PreservationSpaceRoutesEnum,
} from "@shared/enums/routes.enum";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: PreservationSpaceNotificationListRoutable,
    data: {},
  },
  {
    path: PreservationSpaceRoutesEnum.notificationDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: PreservationSpaceNotificationDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: PreservationSpaceNotificationState.currentTitle,
    },
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class PreservationSpaceNotificationRoutingModule {
}
