import {Injectable} from "@angular/core";
import {
  AdminResourceApiEnum,
  PreIngestResourceApiEnum,
} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {Contributor} from "@models";
import {
  Actions,
  Selector,
  State,
  Store,
} from "@ngxs/store";
import {
  defaultPreservationSpaceContributorDepositStateModel,
  PreservationSpaceContributorDepositState,
  PreservationSpaceContributorDepositStateModel,
} from "@preservation-space/contributor/stores/contributor-deposit/preservation-space-contributor-deposit.state";
import {preservationSpaceContributorActionNameSpace} from "@preservation-space/contributor/stores/preservation-space-contributor.action";
import {SecurityService} from "@shared/services/security.service";
import {
  ApiService,
  defaultResourceStateInitValue,
  isNullOrUndefined,
  NotificationService,
  ResourceState,
  ResourceStateModel,
  StoreUtil,
} from "solidify-frontend";
import {
  defaultResourceLogoStateInitValue,
  ResourceLogoState,
  ResourceLogoStateModeEnum,
} from "@shared/stores/resource-logo/resource-logo.state";
import {ResourceLogoStateModel} from "@shared/stores/resource-logo/resource-logo-state.model";
import {HttpClient} from "@angular/common/http";

export interface PreservationSpaceContributorStateModel extends ResourceLogoStateModel<Contributor> {
  preservationSpace_contributor_deposit: PreservationSpaceContributorDepositStateModel;
}

@Injectable()
@State<PreservationSpaceContributorStateModel>({
  name: LocalStateEnum.preservationSpace_contributor,
  defaults: {
    ...defaultResourceLogoStateInitValue(),
    preservationSpace_contributor_deposit: defaultPreservationSpaceContributorDepositStateModel(),
  },
  children: [
    PreservationSpaceContributorDepositState,
  ],
})
export class PreservationSpaceContributorState extends ResourceLogoState<PreservationSpaceContributorStateModel, Contributor> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions,
              private _securityService: SecurityService,
              protected readonly _httpClient: HttpClient) {
    super(apiService, store, notificationService, actions$, {nameSpace: preservationSpaceContributorActionNameSpace},
      _httpClient, ResourceLogoStateModeEnum.avatar);
  }

  protected get _urlResource(): string {
    return PreIngestResourceApiEnum.contributors;
  }

  protected get _urlLogoResource(): string {
    return AdminResourceApiEnum.people;
  }

  @Selector()
  static isLoadingWithDependency(state: PreservationSpaceContributorStateModel): boolean {
    return this.isLoading(state);
  }

  @Selector()
  static isLoading(state: PreservationSpaceContributorStateModel): boolean {
    return StoreUtil.isLoadingState(state);
  }

  @Selector()
  static currentTitle(state: PreservationSpaceContributorStateModel): string | undefined {
    if (isNullOrUndefined(state.current)) {
      return undefined;
    }
    return state.current.fullName;
  }

  @Selector()
  static isReadyToBeDisplayed(state: PreservationSpaceContributorStateModel): boolean {
    return !isNullOrUndefined(state.current);
  }
}
