import {Injectable} from "@angular/core";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {Deposit} from "@models";
import {
  Actions,
  Selector,
  State,
  Store,
} from "@ngxs/store";
import {preservationSpaceContributorDepositActionNameSpace} from "@preservation-space/contributor/stores/contributor-deposit/preservation-space-contributor-deposit.action";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {PreIngestResourceApiEnum} from "@shared/enums/api.enum";
import {
  ApiService,
  CompositionState,
  CompositionStateModel,
  defaultCompositionStateInitValue,
  isNullOrUndefined,
  NotificationService,
  StoreUtil,
} from "solidify-frontend";

export const defaultPreservationSpaceContributorDepositStateModel: () => PreservationSpaceContributorDepositStateModel = () =>
  ({
    ...defaultCompositionStateInitValue(),
  });

export interface PreservationSpaceContributorDepositStateModel extends CompositionStateModel<Deposit> {
}

@Injectable()
@State<PreservationSpaceContributorDepositStateModel>({
  name: LocalStateEnum.preservationSpace_contributor_deposit,
  defaults: {
    ...defaultPreservationSpaceContributorDepositStateModel(),
  },
})
export class PreservationSpaceContributorDepositState extends CompositionState<PreservationSpaceContributorDepositStateModel, Deposit> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: preservationSpaceContributorDepositActionNameSpace,
      resourceName: ApiResourceNameEnum.DEPOSIT,
    });
  }

  protected get _urlResource(): string {
    return PreIngestResourceApiEnum.contributors;
  }

  @Selector()
  static currentTitle(state: PreservationSpaceContributorDepositStateModel): string | undefined {
    if (isNullOrUndefined(state.current)) {
      return undefined;
    }
    return state.current.title;
  }

  @Selector()
  static isReadyToBeDisplayed(state: PreservationSpaceContributorDepositStateModel): boolean {
    return !isNullOrUndefined(state.current);
  }

  @Selector()
  static isLoading(state: PreservationSpaceContributorDepositStateModel): boolean {
    return StoreUtil.isLoadingState(state);
  }
}
