import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {PreservationSpaceContributorFormPresentational} from "@preservation-space/contributor/components/presentationals/contributor-form/preservation-space-contributor-form.presentational";
import {PreservationSpaceContributorDetailEditRoutable} from "@preservation-space/contributor/components/routables/contributor-detail-edit/preservation-space-contributor-detail-edit.routable";
import {PreservationSpaceContributorListRoutable} from "@preservation-space/contributor/components/routables/contributor-list/preservation-space-contributor-list.routable";
import {PreservationSpaceContributorRoutingModule} from "@preservation-space/contributor/preservation-space-contributor-routing.module";
import {PreservationSpaceContributorDepositState} from "@preservation-space/contributor/stores/contributor-deposit/preservation-space-contributor-deposit.state";

const routables = [
  PreservationSpaceContributorListRoutable,
  PreservationSpaceContributorDetailEditRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [
  PreservationSpaceContributorFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    PreservationSpaceContributorRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      PreservationSpaceContributorDepositState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class PreservationSpaceContributorModule {
}
