import {NgModule} from "@angular/core";
import {RouterModule} from "@angular/router";
import {DlcmRoutes} from "@app/shared/models/dlcm-route.model";
import {PreservationSpaceContributorDetailEditRoutable} from "@preservation-space/contributor/components/routables/contributor-detail-edit/preservation-space-contributor-detail-edit.routable";
import {PreservationSpaceContributorListRoutable} from "@preservation-space/contributor/components/routables/contributor-list/preservation-space-contributor-list.routable";
import {PreservationSpaceContributorState} from "@preservation-space/contributor/stores/preservation-space-contributor.state";
import {
  AppRoutesEnum,
  ContributorRoutesEnum,
} from "@shared/enums/routes.enum";

const routes: DlcmRoutes = [
  {
    path: AppRoutesEnum.root,
    component: PreservationSpaceContributorListRoutable,
    data: {},
    children: [],
  },
  {
    path: ContributorRoutesEnum.detail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: PreservationSpaceContributorDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: PreservationSpaceContributorState.currentTitle,
    },
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class PreservationSpaceContributorRoutingModule {
}
