import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {
  Aip,
  Contributor,
} from "@models";
import {Navigate} from "@ngxs/router-plugin";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {preservationSpaceContributorActionNameSpace} from "@preservation-space/contributor/stores/preservation-space-contributor.action";
import {
  PreservationSpaceContributorState,
  PreservationSpaceContributorStateModel,
} from "@preservation-space/contributor/stores/preservation-space-contributor.state";
import {SharedAbstractListRoutable} from "@shared/components/routables/shared-abstract-list/shared-abstract-list.routable";
import {DataTableComponentEnum} from "@shared/enums/data-table-component.enum";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {RouterExtService} from "@shared/services/router-ext.service";
import {SecurityService} from "@shared/services/security.service";
import {
  MappingObjectUtil,
  OrderEnum,
  Override,
  OverrideProperty,
  QueryParameters,
  ResourceActionHelper,
} from "solidify-frontend";

@Component({
  selector: "dlcm-preservation-space-contributor-list-routable",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PreservationSpaceContributorListRoutable extends SharedAbstractListRoutable<Contributor, PreservationSpaceContributorStateModel> {
  readonly KEY_CREATE_BUTTON: string = undefined;
  readonly KEY_BACK_BUTTON: string | undefined = undefined;
  readonly KEY_PARAM_NAME: keyof Contributor & string = "resId";

  @OverrideProperty()
  stickyTopPosition: number = 0;

  preservationSpaceContributorState: typeof PreservationSpaceContributorState = PreservationSpaceContributorState;

  constructor(protected readonly _store: Store,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _route: ActivatedRoute,
              protected readonly _routerExt: RouterExtService,
              protected readonly _actions$: Actions,
              protected readonly _dialog: MatDialog,
              private readonly _securityService: SecurityService) {
    super(_store, _changeDetector, _route, _routerExt, _actions$, _dialog, LocalStateEnum.preservationSpace_contributor, preservationSpaceContributorActionNameSpace,
      {
        canCreate: false,
        canRefresh: true,
        canGoBack: false,
      }, LocalStateEnum.preservationSpace);
  }

  conditionDisplayEditButton(model: Contributor | undefined): boolean {
    return false;
  }

  conditionDisplayDeleteButton(model: Contributor | undefined): boolean {
    return false;
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "avatar",
        header: LabelTranslateEnum.avatar,
        order: OrderEnum.none,
        resourceNameSpace: preservationSpaceContributorActionNameSpace,
        resourceState: this.preservationSpaceContributorState as any,
        isFilterable: false,
        isSortable: false,
        component: DataTableComponentEnum.logo,
        isUser: true,
      },
      {
        field: "lastName",
        header: LabelTranslateEnum.lastName,
        type: FieldTypeEnum.string,
        order: OrderEnum.ascending,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "firstName",
        header: LabelTranslateEnum.firstName,
        type: FieldTypeEnum.string,
        order: OrderEnum.ascending,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "orcid",
        header: LabelTranslateEnum.orcid,
        type: FieldTypeEnum.string,
        order: OrderEnum.ascending,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "depositNumber",
        header: LabelTranslateEnum.deposits,
        type: FieldTypeEnum.number,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: false,
      },
      {
        field: "creation.when" as any,
        header: LabelTranslateEnum.created,
        type: FieldTypeEnum.date,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "lastUpdate.when" as any,
        header: LabelTranslateEnum.updated,
        type: FieldTypeEnum.date,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
      },
    ];
  }

  @Override()
  onQueryParametersEvent(queryParameters: QueryParameters, needCopy: boolean = true): void {
    //we cannot sort when filtering by any field of contributor
    if (MappingObjectUtil.size(queryParameters.search.searchItems) > 0) {
      this.columns.forEach(p => p.isSortable = false);
      queryParameters.sort = undefined;
    } else {
      this.defineColumns();
    }
    this.columns = [...this.columns];
    this._store.dispatch(ResourceActionHelper.changeQueryParameters(preservationSpaceContributorActionNameSpace, queryParameters, true));
    this._changeDetector.detectChanges(); // Allow to display spinner the first time
  }

  @Override()
  showDetail(model: Aip): void {
    this._store.dispatch(new Navigate([RoutesEnum.preservationSpaceContributorDetail, model.resId]));
  }
}
