import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnInit,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {appAuthorizedOrganizationalUnitNameSpace} from "@app/stores/authorized-organizational-unit/app-authorized-organizational-unit.action";
import {AppAuthorizedOrganizationalUnitState} from "@app/stores/authorized-organizational-unit/app-authorized-organizational-unit.state";
import {
  Contributor,
  Deposit,
  OrganizationalUnit,
} from "@models";
import {Navigate} from "@ngxs/router-plugin";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {PreservationSpaceContributorDepositAction} from "@preservation-space/contributor/stores/contributor-deposit/preservation-space-contributor-deposit.action";
import {PreservationSpaceContributorDepositState} from "@preservation-space/contributor/stores/contributor-deposit/preservation-space-contributor-deposit.state";
import {preservationSpaceContributorActionNameSpace} from "@preservation-space/contributor/stores/preservation-space-contributor.action";
import {
  PreservationSpaceContributorState,
  PreservationSpaceContributorStateModel,
} from "@preservation-space/contributor/stores/preservation-space-contributor.state";
import {SharedAbstractDetailEditCommonRoutable} from "@shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable";
import {DataTableComponentEnum} from "@shared/enums/data-table-component.enum";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  DepositRoutesEnum,
  RoutesEnum,
} from "@shared/enums/routes.enum";
import {DataTableColumns} from "@shared/models/data-table-columns.model";
import {sharedContributorActionNameSpace} from "@shared/stores/contributor/shared-contributor.action";
import {Observable} from "rxjs";
import {
  MemoizedUtil,
  OrderEnum,
  OverrideProperty,
  QueryParameters,
  ResourceNameSpace,
  Sort,
} from "solidify-frontend";

@Component({
  selector: "dlcm-preservation-space-contributor-detail-edit-routable",
  templateUrl: "./preservation-space-contributor-detail-edit.routable.html",
  styleUrls: ["./preservation-space-contributor-detail-edit.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PreservationSpaceContributorDetailEditRoutable extends SharedAbstractDetailEditCommonRoutable<Contributor, PreservationSpaceContributorStateModel> implements OnInit {
  @Select(PreservationSpaceContributorState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(PreservationSpaceContributorState.isReadyToBeDisplayed) isReadyToBeDisplayedObs: Observable<boolean>;

  listDepositObs: Observable<Deposit[]> = MemoizedUtil.list(this._store, PreservationSpaceContributorDepositState);
  queryParametersDepositObs: Observable<QueryParameters> = MemoizedUtil.queryParameters(this._store, PreservationSpaceContributorDepositState);
  isLoadingDepositObs: Observable<boolean> = MemoizedUtil.isLoading(this._store, PreservationSpaceContributorDepositState);

  appAuthorizedOrganizationalUnitSort: Sort<OrganizationalUnit> = {
    field: "name",
    order: OrderEnum.ascending,
  };
  appAuthorizedOrganizationalUnitNameSpace: ResourceNameSpace = appAuthorizedOrganizationalUnitNameSpace;
  appAuthorizedOrganizationalUnitState: typeof AppAuthorizedOrganizationalUnitState = AppAuthorizedOrganizationalUnitState;

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedContributorActionNameSpace;

  @OverrideProperty()
  readonly editAvailable: boolean = false;

  @OverrideProperty()
  readonly deleteAvailable: boolean = false;

  readonly KEY_PARAM_NAME: keyof Contributor & string = undefined;
  columns: DataTableColumns[] = [
    {
      field: "title",
      header: LabelTranslateEnum.title,
      type: FieldTypeEnum.string,
      order: OrderEnum.none,
      isFilterable: false,
      isSortable: false,
    },
    {
      field: "organizationalUnitId" as any,
      header: LabelTranslateEnum.organizationalUnit,
      type: FieldTypeEnum.searchableSingleSelect,
      order: OrderEnum.none,
      component: DataTableComponentEnum.organizationalUnitName,
      isFilterable: false,
      isSortable: false,
      resourceNameSpace: this.appAuthorizedOrganizationalUnitNameSpace,
      resourceState: this.appAuthorizedOrganizationalUnitState as any,
      searchableSingleSelectSort: this.appAuthorizedOrganizationalUnitSort,
    },
    {
      field: "publicationDate",
      header: LabelTranslateEnum.publicationDate,
      type: FieldTypeEnum.date,
      order: OrderEnum.none,
      isFilterable: false,
      isSortable: false,
    },
    {
      field: "creation.when" as any,
      header: LabelTranslateEnum.created,
      type: FieldTypeEnum.datetime,
      order: OrderEnum.none,
      isFilterable: true,
      isSortable: true,
    },
    {
      field: "lastUpdate.when" as any,
      header: LabelTranslateEnum.updated,
      type: FieldTypeEnum.datetime,
      order: OrderEnum.descending,
      isFilterable: true,
      isSortable: true,
    },
  ];

  constructor(protected _store: Store,
              protected _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              public _dialog: MatDialog) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.preservationSpace_contributor, preservationSpaceContributorActionNameSpace, LocalStateEnum.preservationSpace);
  }

  ngOnInit(): void {
    super.ngOnInit();
  }

  getSubResourceWithParentId(id: string): void {
    this._store.dispatch(new PreservationSpaceContributorDepositAction.GetAll(id));
  }

  onQueryParametersEvent(queryParameters: QueryParameters): void {
    this._store.dispatch(new PreservationSpaceContributorDepositAction.ChangeQueryParameters(this._resId, queryParameters, true));
  }

  goToDeposit(deposit: Deposit): void {
    this._store.dispatch(new Navigate([RoutesEnum.deposit, deposit.organizationalUnitId, DepositRoutesEnum.detail, deposit.resId]));
  }

  navigateToPerson(): void {
    this.navigate([RoutesEnum.adminPersonDetail, this._resId]);
  }

}
