import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ElementRef,
  Output,
} from "@angular/core";
import {FormBuilder} from "@angular/forms";
import {Contributor} from "@models";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {BreakpointService} from "@shared/services/breakpoint.service";
import {SecurityService} from "@shared/services/security.service";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {
  isNullOrUndefined,
  ObservableUtil,
  PropertyName,
} from "solidify-frontend";

@Component({
  selector: "dlcm-preservation-space-contributor-form",
  templateUrl: "./preservation-space-contributor-form.presentational.html",
  styleUrls: ["./preservation-space-contributor-form.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PreservationSpaceContributorFormPresentational extends SharedAbstractFormPresentational<Contributor> {
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  protected readonly _navigatePersonBS: BehaviorSubject<void | undefined> = new BehaviorSubject<void | undefined>(undefined);
  @Output("navigatePerson")
  readonly navigatePersonObs: Observable<void | undefined> = ObservableUtil.asObservable(this._navigatePersonBS);

  constructor(protected readonly _changeDetectorRef: ChangeDetectorRef,
              protected readonly _elementRef: ElementRef,
              private readonly _fb: FormBuilder,
              public readonly securityService: SecurityService,
              public readonly breakpointService: BreakpointService) {
    super(_changeDetectorRef, _elementRef);
  }

  protected initNewForm(): void {
    this.form = this._fb.group({
      [this.formDefinition.lastName]: [""],
      [this.formDefinition.firstName]: [""],
      [this.formDefinition.orcid]: [""],
    });
  }

  protected bindFormTo(contributor: Contributor): void {
    this.form = this._fb.group({
      [this.formDefinition.lastName]: [contributor.lastName],
      [this.formDefinition.firstName]: [contributor.firstName],
      [this.formDefinition.orcid]: [contributor.orcid],
    });
  }

  protected treatmentBeforeSubmit(model: Contributor): Contributor {
    return undefined;
  }

  navigateTo($event?: MouseEvent): void {
    this._navigatePersonBS.next();
    if (!isNullOrUndefined($event)) {
      $event.stopPropagation();
    }
  }
}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() lastName: string;
  @PropertyName() firstName: string;
  @PropertyName() orcid: string;
}
