import {
  ChangeDetectionStrategy,
  Component,
  Input,
} from "@angular/core";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {
  PreservationSpaceRoutesEnum,
  RoutesEnum,
} from "@app/shared/enums/routes.enum";
import {LocalStateModel} from "@app/shared/models/local-state.model";
import {AppNotificationInboxState} from "@app/stores/notification-inbox/app-notification-inbox.state";
import {Enums} from "@enums";
import {Navigate} from "@ngxs/router-plugin";
import {Store} from "@ngxs/store";
import {Tab} from "@shared/components/containers/shared-tabs/shared-tabs.container";
import {DataTestEnum} from "@shared/enums/data-test.enum";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {TourEnum} from "@shared/enums/tour.enum";
import {Observable} from "rxjs";
import {MemoizedUtil} from "solidify-frontend";

@Component({
  selector: "dlcm-preservation-space-home-routable",
  templateUrl: "./preservation-space-home.routable.html",
  styleUrls: ["./preservation-space-home.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PreservationSpaceHomeRoutable extends SharedAbstractPresentational {

  //isLoadingObs: Observable<boolean> = MemoizedUtil.isLoading(this.store, PreservationSpaceState);
  isLoadingObs: Observable<boolean>;

  @Input()
  isLoading: boolean;

  userRolesObs: Enums.UserApplicationRole.UserApplicationRoleEnum[];

  private get rootUrl(): string[] {
    return [RoutesEnum.preservationSpace];
  }

  preservationSpaceTabs: Tab[] = [
    {
      id: "ORGANIZATIONAL_UNIT",
      icon: IconNameEnum.organizationalUnit,
      titleToTranslate: LabelTranslateEnum.organizationalUnits,
      suffixUrl: PreservationSpaceRoutesEnum.organizationalUnit,
      route: () => [...this.rootUrl, PreservationSpaceRoutesEnum.organizationalUnit],
      dataTest: DataTestEnum.preservationSpaceTabOrgUnit,
    },
    {
      id: "CONTRIBUTOR",
      icon: IconNameEnum.contributor,
      titleToTranslate: LabelTranslateEnum.contributors,
      suffixUrl: PreservationSpaceRoutesEnum.contributor,
      route: () => [...this.rootUrl, PreservationSpaceRoutesEnum.contributor],
      dataTest: DataTestEnum.preservationSpaceTabContributor,
    },
    {
      id: "NOTIFICATION_RECEIVED",
      icon: IconNameEnum.requestInbox,
      titleToTranslate: LabelTranslateEnum.notifications,
      suffixUrl: PreservationSpaceRoutesEnum.notificationInbox,
      route: () => [...this.rootUrl, PreservationSpaceRoutesEnum.notificationInbox],
      numberNew: () => MemoizedUtil.total(this.store, AppNotificationInboxState),
      dataTest: DataTestEnum.preservationSpaceTabRequestReceived,
    },
    {
      id: "NOTIFICATION_SENT",
      icon: IconNameEnum.requestSent,
      titleToTranslate: LabelTranslateEnum.sentRequests,
      suffixUrl: PreservationSpaceRoutesEnum.notificationSent,
      route: () => [...this.rootUrl, PreservationSpaceRoutesEnum.notificationSent],
      dataTest: DataTestEnum.preservationSpaceTabRequestSent,
    },
  ];

  get tourEnum(): typeof TourEnum {
    return TourEnum;
  }

  constructor(private store: Store) {
    super();
    this.userRolesObs = this.store.selectSnapshot((state: LocalStateModel) => state.application.userRoles);
  }

  navigate(path: RoutesEnum): void {
    this.store.dispatch(new Navigate([path]));
  }

  private currentTab: Tab;

  setCurrentTab($event: Tab): void {
    this.currentTab = $event;
  }

}
