import {HttpClientTestingModule} from "@angular/common/http/testing";
import {NO_ERRORS_SCHEMA} from "@angular/core";
import {
  async,
  ComponentFixture,
  TestBed,
} from "@angular/core/testing";
import {ReactiveFormsModule} from "@angular/forms";
import {SharedSearchPresentational} from "@app/shared/components/presentationals/shared-search/shared-search.presentational";
import {TranslateService} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {MockTranslatePipe} from "../../../../../../test-helpers/mock-translate.pipe";
import {MockTranslateService} from "../../../../../../test-helpers/mock-translate.service";

import {PreservationSpaceHomeRoutable} from "./preservation-space-home.routable";

describe("AdminHomeRoutable", () => {
  let component: PreservationSpaceHomeRoutable;
  let fixture: ComponentFixture<PreservationSpaceHomeRoutable>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [ReactiveFormsModule, HttpClientTestingModule, NgxsModule.forRoot([])],
      declarations: [PreservationSpaceHomeRoutable, SharedSearchPresentational, MockTranslatePipe],
      providers: [
        {
          provide: TranslateService,
          useClass: MockTranslateService,
        },
      ],
      schemas: [NO_ERRORS_SCHEMA],
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(PreservationSpaceHomeRoutable);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  xit("should create", () => {
    expect(component).toBeTruthy();
  });
});
