import {NgModule} from "@angular/core";
import {PreservationSpaceAipStewardNotFoundRoutable} from "@preservation-space/aip-steward/components/routables/aip-steward-not-found/preservation-space-aip-steward-not-found.routable";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AppRoutesEnum,
  PreservationSpaceAipStewardRoutesEnum,
} from "@shared/enums/routes.enum";
import {SharedAipCollectionDetailRoutable} from "@shared/features/aip/components/routables/aip-collection-detail/shared-aip-collection-detail.routable";
import {SharedAipCollectionRoutable} from "@shared/features/aip/components/routables/aip-collection/shared-aip-collection.routable";
import {SharedAipDetailEditRoutable} from "@shared/features/aip/components/routables/aip-detail-edit/shared-aip-detail-edit.routable";
import {SharedAipFileDetailRoutable} from "@shared/features/aip/components/routables/aip-file-detail/shared-aip-file-detail.routable";
import {SharedAipFileRoutable} from "@shared/features/aip/components/routables/aip-file/shared-aip-file.routable";
import {SharedAipMetadataRoutable} from "@shared/features/aip/components/routables/aip-metadata/shared-aip-metadata.routable";
import {SharedAipSharedModule} from "@shared/features/aip/shared-aip-shared.module";
import {SharedAipState} from "@shared/features/aip/stores/shared-aip.state";
import {DlcmRoutes} from "@shared/models/dlcm-route.model";

const routes: DlcmRoutes = [
  {
    path: PreservationSpaceAipStewardRoutesEnum.aipStewardNotFound + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: PreservationSpaceAipStewardNotFoundRoutable,
  },
  {
    path: PreservationSpaceAipStewardRoutesEnum.aipStewardDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    redirectTo: PreservationSpaceAipStewardRoutesEnum.aipStewardDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId + AppRoutesEnum.separator + PreservationSpaceAipStewardRoutesEnum.aipStewardMetadata,
    pathMatch: "full",
  },
  {
    path: PreservationSpaceAipStewardRoutesEnum.aipStewardDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: SharedAipDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: SharedAipState.currentAipName,
      noBreadcrumbLink: true,
    },
    children: [
      {
        path: PreservationSpaceAipStewardRoutesEnum.aipStewardMetadata,
        component: SharedAipMetadataRoutable,
        data: {
          breadcrumb: LabelTranslateEnum.metadata,
          noBreadcrumbLink: true,
        },
      },
      {
        path: PreservationSpaceAipStewardRoutesEnum.aipStewardCollection,
        component: SharedAipCollectionRoutable,
        data: {
          breadcrumb: LabelTranslateEnum.collection,
          noBreadcrumbLink: true,
        },
        children: [
          {
            path: AppRoutesEnum.paramId,
            component: SharedAipCollectionDetailRoutable,
            data: {
              breadcrumb: LabelTranslateEnum.detail,
            },
          },
        ],
      },
      {
        path: PreservationSpaceAipStewardRoutesEnum.aipStewardFiles,
        component: SharedAipFileRoutable,
        data: {
          breadcrumb: LabelTranslateEnum.files,
          noBreadcrumbLink: true,
        },
        children: [
          {
            path: AppRoutesEnum.paramId,
            component: SharedAipFileDetailRoutable,
            data: {
              breadcrumb: LabelTranslateEnum.detail,
            },
          },
        ],
      },
    ],
  },
];

@NgModule({
  imports: [SharedAipSharedModule.forChild(routes)],
  exports: [SharedAipSharedModule],
})
export class PreservationSpaceAipStewardRoutingModule {
}
