import {
  ChangeDetectionStrategy,
  Component,
} from "@angular/core";
import {
  ActivatedRoute,
  Router,
} from "@angular/router";
import {Navigate} from "@ngxs/router-plugin";
import {Store} from "@ngxs/store";
import {SharedAbstractRoutable} from "@shared/components/routables/shared-abstract/shared-abstract.routable";
import {RoutesEnum} from "@shared/enums/routes.enum";

@Component({
  selector: "dlcm-preservation-space-aip-steward-not-found-routable",
  templateUrl: "./preservation-space-aip-steward-not-found.routable.html",
  styleUrls: ["./preservation-space-aip-steward-not-found.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PreservationSpaceAipStewardNotFoundRoutable extends SharedAbstractRoutable {
  constructor(private readonly _store: Store,
              private readonly _route: ActivatedRoute,
              private readonly _router: Router) {
    super();
  }

  back(): void {
    this.navigate([RoutesEnum.preservationPlanningAipDownloaded]);
  }

  private navigate(path: (string | number)[]): void {
    this._store.dispatch(new Navigate(path));
  }
}
