import {Injectable} from "@angular/core";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {
  State,
  Store,
} from "@ngxs/store";
import {
  PreservationPlanningAipStatusState,
  PreservationPlanningAipStatusStateModel,
} from "@preservation-planning/aip-status/stores/preservation-planning-aip-status.state";
import {
  PreservationPlanningDipState,
  PreservationPlanningDipStateModel,
} from "@preservation-planning/dip/stores/preservation-planning-dip.state";
import {
  PreservationPlanningJobState,
  PreservationPlanningJobStateModel,
} from "@preservation-planning/job/stores/preservation-planning-job.state";
import {
  PreservationPlanningMonitoringState,
  PreservationPlanningMonitoringStateModel,
} from "@preservation-planning/monitoring/stores/preservation-planning-monitoring.state";
import {
  PreservationPlanningSipState,
  PreservationPlanningSipStateModel,
} from "@preservation-planning/sip/stores/preservation-planning-sip.state";
import {BaseStateModel} from "solidify-frontend";
import {
  PreservationPlanningDepositState,
  PreservationPlanningDepositStateModel,
} from "@preservation-planning/deposit/stores/preservation-planning-deposit.state";

export interface PreservationPlanningStateModel extends BaseStateModel {
  [LocalStateEnum.preservationPlanning_deposit]: PreservationPlanningDepositStateModel | undefined;
  [LocalStateEnum.preservationPlanning_monitoring]: PreservationPlanningMonitoringStateModel | undefined;
  [LocalStateEnum.preservationPlanning_job]: PreservationPlanningJobStateModel | undefined;
  [LocalStateEnum.preservationPlanning_aipStatus]: PreservationPlanningAipStatusStateModel | undefined;
  [LocalStateEnum.preservationPlanning_sip]: PreservationPlanningSipStateModel | undefined;
  [LocalStateEnum.preservationPlanning_dip]: PreservationPlanningDipStateModel | undefined;
}

@Injectable()
@State<PreservationPlanningStateModel>({
  name: LocalStateEnum.preservationPlanning,
  defaults: {
    isLoadingCounter: 0,
    [LocalStateEnum.preservationPlanning_deposit]: undefined,
    [LocalStateEnum.preservationPlanning_monitoring]: undefined,
    [LocalStateEnum.preservationPlanning_job]: undefined,
    [LocalStateEnum.preservationPlanning_aipStatus]: undefined,
    [LocalStateEnum.preservationPlanning_sip]: undefined,
    [LocalStateEnum.preservationPlanning_dip]: undefined,
  },
  children: [
    PreservationPlanningDepositState,
    PreservationPlanningMonitoringState,
    PreservationPlanningJobState,
    PreservationPlanningAipStatusState,
    PreservationPlanningSipState,
    PreservationPlanningDipState,
  ],
})
export class PreservationPlanningState {
  constructor(protected store: Store) {
  }
}
