import {Injectable} from "@angular/core";
import {preservationPlanningSipStatusHistoryNamespace} from "@preservation-planning/sip/stores/status-history/preservation-planning-sip-status-history.action";
import {IngestResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {Sip} from "@models";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {
  defaultStatusHistoryInitValue,
  StatusHistoryState,
  StatusHistoryStateModel,
} from "@shared/stores/status-history/status-history.state";
import {
  ApiService,
  NotificationService,
} from "solidify-frontend";

export interface PreservationPlanningSipStatusHistoryStateModel extends StatusHistoryStateModel<Sip> {
}

@Injectable()
@State<PreservationPlanningSipStatusHistoryStateModel>({
  name: LocalStateEnum.preservationPlanning_sip_statusHistory,
  defaults: {
    ...defaultStatusHistoryInitValue(),
  },
})
export class PreservationPlanningSipStatusHistoryState extends StatusHistoryState<PreservationPlanningSipStatusHistoryStateModel, Sip> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: preservationPlanningSipStatusHistoryNamespace,
    });
  }

  protected get _urlResource(): string {
    return IngestResourceApiEnum.sip;
  }
}
