import {Injectable} from "@angular/core";
import {IngestResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {SipDataFile} from "@preservation-planning/sip/models/sip-data-file.model";
import {preservationPlanningSipDataFileStatusHistoryNamespace} from "@preservation-planning/sip/stores/data-file/status-history/preservation-planning-sip-data-file-status-history.action";
import {
  defaultStatusHistoryInitValue,
  StatusHistoryState,
  StatusHistoryStateModel,
} from "@shared/stores/status-history/status-history.state";
import {
  ApiService,
  NotificationService,
} from "solidify-frontend";

export interface SharedAipDataFileStatusHistoryStateModel extends StatusHistoryStateModel<SipDataFile> {
}

@Injectable()
@State<SharedAipDataFileStatusHistoryStateModel>({
  name: LocalStateEnum.preservationPlanning_sip_dataFile_statusHistory,
  defaults: {
    ...defaultStatusHistoryInitValue(),
  },
})
export class PreservationPlanningSipDataFileStatusHistoryState extends StatusHistoryState<SharedAipDataFileStatusHistoryStateModel, SipDataFile> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: preservationPlanningSipDataFileStatusHistoryNamespace,
    });
  }

  protected get _urlResource(): string {
    return IngestResourceApiEnum.sipDataFile;
  }
}
