import {Injectable} from "@angular/core";
import {ArchivalStorageResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {Aip} from "@models";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {preservationPlanningSipCollectionStatusHistoryNamespace} from "@preservation-planning/sip/stores/collection/status-history/preservation-planning-sip-collection-status-history.action";
import {
  defaultStatusHistoryInitValue,
  StatusHistoryState,
  StatusHistoryStateModel,
} from "@shared/stores/status-history/status-history.state";
import {
  ApiService,
  NotificationService,
} from "solidify-frontend";

export interface PreservationPlanningSipCollectionStatusHistoryStateModel extends StatusHistoryStateModel<Aip> {
}

@Injectable()
@State<PreservationPlanningSipCollectionStatusHistoryStateModel>({
  name: LocalStateEnum.preservationPlanning_sip_collection_statusHistory,
  defaults: {
    ...defaultStatusHistoryInitValue(),
  },
})
export class PreservationPlanningSipCollectionStatusHistoryState extends StatusHistoryState<PreservationPlanningSipCollectionStatusHistoryStateModel, Aip> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: preservationPlanningSipCollectionStatusHistoryNamespace,
    });
  }

  protected get _urlResource(): string {
    return ArchivalStorageResourceApiEnum.aip;
  }
}
