import {
  Inject,
  Injectable,
} from "@angular/core";
import {WINDOW} from "@app/app.module";
import {ApiResourceNameEnum} from "@app/shared/enums/api-resource-name.enum";
import {IngestResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {Aip} from "@models";
import {Navigate} from "@ngxs/router-plugin";
import {
  Action,
  Actions,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {
  PreservationPlanningSipCollectionAction,
  preservationPlanningSipCollectionActionNameSpace,
} from "@preservation-planning/sip/stores/collection/preservation-planning-sip-collection.action";
import {
  PreservationPlanningSipCollectionStatusHistoryState,
  PreservationPlanningSipCollectionStatusHistoryStateModel,
} from "@preservation-planning/sip/stores/collection/status-history/preservation-planning-sip-collection-status-history.state";
import {ApiActionEnum} from "@shared/enums/api-action.enum";
import {
  AppRoutesEnum,
  RoutesEnum,
  SharedAipRoutesEnum,
  urlSeparator,
} from "@shared/enums/routes.enum";
import {DownloadService} from "@shared/services/download.service";
import {defaultStatusHistoryInitValue} from "@shared/stores/status-history/status-history.state";
import {
  ApiService,
  CompositionState,
  CompositionStateModel,
  defaultCompositionStateInitValue,
  NotificationService,
} from "solidify-frontend";

export const defaultPreservationPlanningSipDataFileValue: () => PreservationPlanningSipCollectionStateModel = () =>
  ({
    ...defaultCompositionStateInitValue(),
    [LocalStateEnum.preservationPlanning_sip_collection_statusHistory]: defaultStatusHistoryInitValue(),
  });

export interface PreservationPlanningSipCollectionStateModel extends CompositionStateModel<Aip> {
  [LocalStateEnum.preservationPlanning_sip_collection_statusHistory]: PreservationPlanningSipCollectionStatusHistoryStateModel;
}

@Injectable()
@State<PreservationPlanningSipCollectionStateModel>({
  name: LocalStateEnum.preservationPlanning_sip_collection,
  defaults: {
    ...defaultPreservationPlanningSipDataFileValue(),
  },
  children: [
    PreservationPlanningSipCollectionStatusHistoryState,
  ],
})
export class PreservationPlanningSipCollectionState extends CompositionState<PreservationPlanningSipCollectionStateModel, Aip> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions,
              @Inject(WINDOW) private _window: Window,
              private downloadService: DownloadService) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: preservationPlanningSipCollectionActionNameSpace,
      resourceName: ApiResourceNameEnum.AIP,
    });
  }

  protected get _urlResource(): string {
    return IngestResourceApiEnum.sip;
  }

  @Action(PreservationPlanningSipCollectionAction.Refresh)
  refresh(ctx: StateContext<PreservationPlanningSipCollectionStateModel>, action: PreservationPlanningSipCollectionAction.Refresh): void {
    ctx.dispatch(new PreservationPlanningSipCollectionAction.GetAll(action.parentId, undefined, true));
  }

  @Action(PreservationPlanningSipCollectionAction.GoToAip)
  goToAip(ctx: StateContext<PreservationPlanningSipCollectionStateModel>, action: PreservationPlanningSipCollectionAction.GoToAip): void {
    const pathAipDetail = RoutesEnum.preservationPlanningAip + urlSeparator + 1 + urlSeparator + SharedAipRoutesEnum.aipDetail + AppRoutesEnum.separator;
    const path = [pathAipDetail, action.aip.resId];
    ctx.dispatch(new Navigate(path));
  }

  @Action(PreservationPlanningSipCollectionAction.DownloadAip)
  downloadAip(ctx: StateContext<PreservationPlanningSipCollectionStateModel>, action: PreservationPlanningSipCollectionAction.DownloadAip): void {
    // NOT WORK
    const url = `${this._urlResource}/${action.parentId}/${this._resourceName}/${action.aip.resId}/${ApiActionEnum.DL}`;
    this.downloadService.download(false, url, action.aip.info.name, action.aip.archiveSize);
  }
}
