import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnDestroy,
  OnInit,
  ViewChild,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {
  PreservationPlanningSipState,
  PreservationPlanningSipStateModel,
} from "@preservation-planning/sip/stores/preservation-planning-sip.state";
import {DepositFormPresentational} from "@deposit/components/presentationals/deposit-form/deposit-form.presentational";
import {Sip} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {preservationPlanningSipActionNameSpace} from "@preservation-planning/sip/stores/preservation-planning-sip.action";
import {SharedAbstractDetailEditRoutable} from "@shared/components/routables/shared-abstract-detail-edit/shared-abstract-detail-edit.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Observable} from "rxjs";

@Component({
  selector: "dlcm-preservation-planning-sip-metadata-routable",
  templateUrl: "./preservation-planning-sip-metadata.routable.html",
  styleUrls: ["./preservation-planning-sip-metadata.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})

export class PreservationPlanningSipMetadataRoutable extends SharedAbstractDetailEditRoutable<Sip, PreservationPlanningSipStateModel> implements OnInit, OnDestroy {
  @Select(PreservationPlanningSipState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(PreservationPlanningSipState.isReadyToBeDisplayed) isReadyToBeDisplayedObs: Observable<boolean>;

  @ViewChild("formPresentational")
  readonly formPresentational: DepositFormPresentational;

  readonly KEY_PARAM_NAME: keyof Sip & string = undefined;

  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _dialog: MatDialog) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.preservationPlanning_sip, preservationPlanningSipActionNameSpace, LocalStateEnum.preservationPlanning);
  }

  ngOnInit(): void {
    super.ngOnInit();
  }

  ngOnDestroy(): void {
    super.ngOnDestroy();
  }

  protected getSubResourceWithParentId(id: string): void {
  }
}
