import {
  ChangeDetectorRef,
  Component,
  OnInit,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SipDataFile} from "@preservation-planning/sip/models/sip-data-file.model";
import {preservationPlanningSipDataFileActionNameSpace} from "@preservation-planning/sip/stores/data-file/preservation-planning-sip-data-file.action";
import {PreservationPlanningSipDataFileState} from "@preservation-planning/sip/stores/data-file/preservation-planning-sip-data-file.state";
import {preservationPlanningSipDataFileStatusHistoryNamespace} from "@preservation-planning/sip/stores/data-file/status-history/preservation-planning-sip-data-file-status-history.action";
import {PreservationPlanningSipDataFileStatusHistoryState} from "@preservation-planning/sip/stores/data-file/status-history/preservation-planning-sip-data-file-status-history.state";
import {SharedAbstractFileAipDetailRoutable} from "@shared/components/routables/shared-abstract-file-aip-detail/shared-abstract-file-aip-detail.routable";

@Component({
  selector: "dlcm-preservation-planning-sip-file-detail",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-file-aip-detail/shared-abstract-file-aip-detail.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-file-aip-detail/shared-abstract-file-aip-detail.routable.scss"],
})
export class PreservationPlanningSipFileDetailRoutable extends SharedAbstractFileAipDetailRoutable<SipDataFile> implements OnInit {
  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _dialog: MatDialog,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super(_store,
      _route,
      _actions$,
      _dialog,
      _changeDetector,
      PreservationPlanningSipDataFileState,
      preservationPlanningSipDataFileActionNameSpace,
      PreservationPlanningSipDataFileStatusHistoryState,
      preservationPlanningSipDataFileStatusHistoryNamespace);
  }
}
