import {
  ChangeDetectorRef,
  Component,
  OnInit,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {Aip} from "@models";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {preservationPlanningSipCollectionActionNameSpace} from "@preservation-planning/sip/stores/collection/preservation-planning-sip-collection.action";
import {PreservationPlanningSipCollectionState} from "@preservation-planning/sip/stores/collection/preservation-planning-sip-collection.state";
import {preservationPlanningSipCollectionStatusHistoryNamespace} from "@preservation-planning/sip/stores/collection/status-history/preservation-planning-sip-collection-status-history.action";
import {PreservationPlanningSipCollectionStatusHistoryState} from "@preservation-planning/sip/stores/collection/status-history/preservation-planning-sip-collection-status-history.state";
import {SharedAbstractFileAipDetailRoutable} from "@shared/components/routables/shared-abstract-file-aip-detail/shared-abstract-file-aip-detail.routable";

@Component({
  selector: "dlcm-preservation-planning-sip-collection-detail",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-file-aip-detail/shared-abstract-file-aip-detail.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-file-aip-detail/shared-abstract-file-aip-detail.routable.scss"],
})
export class PreservationPlanningSipCollectionDetailRoutable extends SharedAbstractFileAipDetailRoutable<Aip> implements OnInit {
  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _dialog: MatDialog,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super(_store,
      _route,
      _actions$,
      _dialog,
      _changeDetector,
      PreservationPlanningSipCollectionState,
      preservationPlanningSipCollectionActionNameSpace,
      PreservationPlanningSipCollectionStatusHistoryState,
      preservationPlanningSipCollectionStatusHistoryNamespace);
  }
}
