import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {PreservationPlanningAipStatusState} from "@preservation-planning/aip-status/stores/preservation-planning-aip-status.state";
import {PreservationPlanningHomeRoutable} from "@preservation-planning/components/routables/preservation-planning-home/preservation-planning-home.routable";
import {PreservationPlanningDipAipState} from "@preservation-planning/dip/stores/aip/preservation-planning-dip-aip.state";
import {PreservationPlanningDipDataFileState} from "@preservation-planning/dip/stores/data-file/preservation-planning-dip-data-file.state";
import {PreservationPlanningDipDataFileStatusHistoryState} from "@preservation-planning/dip/stores/data-file/status-history/preservation-planning-dip-data-file-status-history.state";
import {PreservationPlanningDipState} from "@preservation-planning/dip/stores/preservation-planning-dip.state";
import {PreservationPlanningDipStatusHistoryState} from "@preservation-planning/dip/stores/status-history/preservation-planning-dip-status-history.state";
import {PreservationPlanningJobExecutionReportState} from "@preservation-planning/job/stores/job-execution/job-execution-report/preservation-planning-job-execution-report.state";
import {PreservationPlanningJobExecutionState} from "@preservation-planning/job/stores/job-execution/preservation-planning-job-execution.state";
import {PreservationPlanningJobState} from "@preservation-planning/job/stores/preservation-planning-job.state";
import {PreservationPlanningMonitoringState} from "@preservation-planning/monitoring/stores/preservation-planning-monitoring.state";
import {PreservationPlanningMonitoringWebServiceState} from "@preservation-planning/monitoring/stores/web-service/preservation-planning-monitoring-web-service.state";
import {PreservationPlanningRoutingModule} from "@preservation-planning/preservation-planning-routing.module";
import {PreservationPlanningSipCollectionState} from "@preservation-planning/sip/stores/collection/preservation-planning-sip-collection.state";
import {PreservationPlanningSipCollectionStatusHistoryState} from "@preservation-planning/sip/stores/collection/status-history/preservation-planning-sip-collection-status-history.state";
import {PreservationPlanningSipDataFileState} from "@preservation-planning/sip/stores/data-file/preservation-planning-sip-data-file.state";
import {PreservationPlanningSipDataFileStatusHistoryState} from "@preservation-planning/sip/stores/data-file/status-history/preservation-planning-sip-data-file-status-history.state";
import {PreservationPlanningSipState} from "@preservation-planning/sip/stores/preservation-planning-sip.state";
import {PreservationPlanningSipStatusHistoryState} from "@preservation-planning/sip/stores/status-history/preservation-planning-sip-status-history.state";
import {PreservationPlanningState} from "@preservation-planning/stores/preservation-planning.state";
import {ModuleLoadedEnum} from "@shared/enums/module-loaded.enum";
import {PreservationPlanningDepositState} from "@preservation-planning/deposit/stores/preservation-planning-deposit.state";

const routables = [
  PreservationPlanningHomeRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    PreservationPlanningRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      PreservationPlanningState,
      PreservationPlanningMonitoringState,
      PreservationPlanningMonitoringWebServiceState,
      PreservationPlanningAipStatusState,
      PreservationPlanningJobState,
      PreservationPlanningJobExecutionState,
      PreservationPlanningJobExecutionReportState,
      PreservationPlanningSipState,
      PreservationPlanningSipStatusHistoryState,
      PreservationPlanningSipDataFileState,
      PreservationPlanningSipDataFileStatusHistoryState,
      PreservationPlanningSipCollectionState,
      PreservationPlanningSipCollectionStatusHistoryState,
      PreservationPlanningDipState,
      PreservationPlanningDipDataFileState,
      PreservationPlanningDipStatusHistoryState,
      PreservationPlanningDipDataFileStatusHistoryState,
      PreservationPlanningDipAipState,
      PreservationPlanningDepositState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class PreservationPlanningModule {
  constructor() {
    window[ModuleLoadedEnum.preservationPlanningModuleLoaded] = true;
  }
}
