import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {
  AppRoutesEnum,
  PreservationPlanningRoutesEnum,
} from "@app/shared/enums/routes.enum";
import {PreservationPlanningHomeRoutable} from "@preservation-planning/components/routables/preservation-planning-home/preservation-planning-home.routable";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {ApplicationRoleGuardService} from "@shared/guards/application-role-guard.service";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: PreservationPlanningHomeRoutable,
    data: {},
  },
  {
    path: PreservationPlanningRoutesEnum.deposit,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./deposit/preservation-planning-deposit.module").then(m => m.PreservationPlanningDepositModule),
    data: {
      breadcrumb: LabelTranslateEnum.deposit,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: PreservationPlanningRoutesEnum.monitoring,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./monitoring/preservation-planning-monitoring.module").then(m => m.PreservationPlanningMonitoringModule),
    data: {
      breadcrumb: LabelTranslateEnum.monitoring,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: PreservationPlanningRoutesEnum.aipStatuses,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./aip-status/preservation-planning-aip-status.module").then(m => m.PreservationPlanningAipStatusModule),
    data: {
      breadcrumb: LabelTranslateEnum.aipStatuses,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: PreservationPlanningRoutesEnum.job,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./job/preservation-planning-job.module").then(m => m.PreservationPlanningJobModule),
    data: {
      breadcrumb: LabelTranslateEnum.jobs,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: PreservationPlanningRoutesEnum.aip,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./aip/preservation-planning-aip.module").then(m => m.PreservationPlanningAipModule),
    data: {
      breadcrumb: LabelTranslateEnum.aip,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: PreservationPlanningRoutesEnum.sip,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./sip/preservation-planning-sip.module").then(m => m.PreservationPlanningSipModule),
    data: {
      breadcrumb: LabelTranslateEnum.sip,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: PreservationPlanningRoutesEnum.dip,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./dip/preservation-planning-dip.module").then(m => m.PreservationPlanningDipModule),
    data: {
      breadcrumb: LabelTranslateEnum.dip,
    },
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: PreservationPlanningRoutesEnum.aipDownloaded,
    // @ts-ignore Dynamic import
    loadChildren: () => import("./aip-downloaded/preservation-planning-aip-downloaded.module").then(m => m.PreservationPlanningAipDownloadedModule),
    data: {
      breadcrumb: LabelTranslateEnum.aipDownloaded,
    },
    canActivate: [ApplicationRoleGuardService],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class PreservationPlanningRoutingModule {

}
