import {HttpClient} from "@angular/common/http";
import {Injectable} from "@angular/core";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {Navigate} from "@ngxs/router-plugin";
import {
  Action,
  Actions,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {
  PreservationPlanningMonitoringWebServiceAction,
  preservationPlanningMonitorWebServiceActionNameSpace,
} from "@preservation-planning/monitoring/stores/web-service/preservation-planning-monitoring-web-service.action";
import {Observable} from "rxjs";
import {
  catchError,
  tap,
} from "rxjs/operators";
import {
  ApiService,
  BaseState,
  BaseStateModel,
  defaultBaseStateInitValue,
  NotificationService,
  SolidifyStateError,
  StoreUtil,
} from "solidify-frontend";

export interface PreservationPlanningMonitoringWebServiceStateModel extends BaseStateModel {
  result: object | undefined;
}

@Injectable()
@State<PreservationPlanningMonitoringWebServiceStateModel>({
  name: LocalStateEnum.preservationPlanning_monitoring_webService,
  defaults: {
    ...defaultBaseStateInitValue(),
    result: undefined,
  },
  children: [],
})
export class PreservationPlanningMonitoringWebServiceState extends BaseState<PreservationPlanningMonitoringWebServiceStateModel> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions,
              private readonly _httpClient: HttpClient) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: preservationPlanningMonitorWebServiceActionNameSpace,
    }, PreservationPlanningMonitoringWebServiceState);
  }

  protected get _urlResource(): string {
    return undefined;
  }

  @Action(PreservationPlanningMonitoringWebServiceAction.Get)
  get(ctx: StateContext<PreservationPlanningMonitoringWebServiceStateModel>, action: PreservationPlanningMonitoringWebServiceAction.Get): Observable<object> {
    let reset = {};
    if (!action.keepCurrentContext) {
      reset = {
        result: undefined,
      };
    }
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter + 1,
      ...reset,
    });

    return this.apiService.getByIdInPath(action.apiUrl).pipe(
      StoreUtil.cancelUncompleted(ctx, this.actions$, [PreservationPlanningMonitoringWebServiceAction.Get, Navigate]),
      tap((result: object) => {
        ctx.dispatch(new PreservationPlanningMonitoringWebServiceAction.GetSuccess(action, result));
      }),
      catchError(error => {
        ctx.dispatch(new PreservationPlanningMonitoringWebServiceAction.GetFail(action));
        throw new SolidifyStateError(this, error);
      }),
    );
  }

  @Action(PreservationPlanningMonitoringWebServiceAction.GetSuccess)
  getAllSuccess(ctx: StateContext<PreservationPlanningMonitoringWebServiceStateModel>, action: PreservationPlanningMonitoringWebServiceAction.GetSuccess): void {
    ctx.patchState({
      result: action.result,
      isLoadingCounter: ctx.getState().isLoadingCounter - 1,
    });
  }

  @Action(PreservationPlanningMonitoringWebServiceAction.GetFail)
  getAllFail(ctx: StateContext<PreservationPlanningMonitoringWebServiceStateModel>, action: PreservationPlanningMonitoringWebServiceAction.GetFail): void {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter - 1,
    });
  }
}
