import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  BaseAction,
  BaseSubAction,
} from "solidify-frontend";

const state = LocalStateEnum.preservationPlanning_monitoring_webService;

export namespace PreservationPlanningMonitoringWebServiceAction {
  export class Get extends BaseAction {
    static readonly type: string = `[${state}] Get`;

    constructor(public apiUrl: string, public keepCurrentContext: boolean = false) {
      super();
    }
  }

  export class GetSuccess extends BaseSubAction<Get> {
    static readonly type: string = `[${state}] Get Success`;

    constructor(public parent: Get, public result: object) {
      super(parent);
    }
  }

  export class GetFail extends BaseSubAction<Get> {
    static readonly type: string = `[${state}] Get Fail`;

    constructor(public parent: Get) {
      super(parent);
    }
  }
}

export const preservationPlanningMonitorWebServiceActionNameSpace = PreservationPlanningMonitoringWebServiceAction;
