import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {PreservationPlanningMonitor} from "@shared/models/business/preservation-planning-monitor.model";
import {
  BaseAction,
  BaseSubAction,
} from "solidify-frontend";

const state = LocalStateEnum.preservationPlanning_monitoring;

export namespace PreservationPlanningMonitoringAction {
  export class Get extends BaseAction {
    static readonly type: string = `[${state}] Get`;

    constructor(public keepCurrentContext: boolean = false) {
      super();
    }
  }

  export class GetSuccess extends BaseSubAction<Get> {
    static readonly type: string = `[${state}] Get Success`;

    constructor(public parent: Get, public preservationPlanningMonitor: PreservationPlanningMonitor) {
      super(parent);
    }
  }

  export class GetFail extends BaseSubAction<Get> {
    static readonly type: string = `[${state}] Get Fail`;

    constructor(public parent: Get) {
      super(parent);
    }
  }
}

export const preservationPlanningMonitorActionNameSpace = PreservationPlanningMonitoringAction;
