import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {PreservationPlanningMonitoringWebServiceDialog} from "@preservation-planning/monitoring/components/dialogs/monitoring-web-service/preservation-planning-monitoring-web-service.dialog";
import {PreservationPlanningMonitoringServicePresentational} from "@preservation-planning/monitoring/components/presentationals/monitoring-service/preservation-planning-monitoring-service.presentational";
import {PreservationPlanningMonitoringHomeRoutable} from "@preservation-planning/monitoring/components/routables/monitoring-home/preservation-planning-monitoring-home.routable";
import {PreservationPlanningMonitoringRoutingModule} from "@preservation-planning/monitoring/preservation-planning-monitoring-routing.module";
import {PreservationPlanningMonitoringState} from "@preservation-planning/monitoring/stores/preservation-planning-monitoring.state";
import {PreservationPlanningMonitoringWebServiceState} from "@preservation-planning/monitoring/stores/web-service/preservation-planning-monitoring-web-service.state";

const routables = [
  PreservationPlanningMonitoringHomeRoutable,
];
const containers = [];
const dialogs = [
  PreservationPlanningMonitoringWebServiceDialog,
];
const presentationals = [
  PreservationPlanningMonitoringServicePresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    PreservationPlanningMonitoringRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      PreservationPlanningMonitoringState,
      PreservationPlanningMonitoringWebServiceState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class PreservationPlanningMonitoringModule {
}
