import {
  ChangeDetectionStrategy,
  Component,
  Input,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {
  MonitoringWebServiceDialogData,
  PreservationPlanningMonitoringWebServiceDialog,
} from "@preservation-planning/monitoring/components/dialogs/monitoring-web-service/preservation-planning-monitoring-web-service.dialog";
import {PreservationPlanningMonitorService} from "@shared/models/business/preservation-planning-monitor.model";
import {
  take,
  tap,
} from "rxjs/operators";
import {
  HateOASLink,
  isArray,
  isNullOrUndefined,
  urlSeparator,
} from "solidify-frontend";

@Component({
  selector: "dlcm-preservation-planning-monitoring-service",
  templateUrl: "./preservation-planning-monitoring-service.presentational.html",
  styleUrls: ["./preservation-planning-monitoring-service.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PreservationPlanningMonitoringServicePresentational extends SharedAbstractPresentational {
  @Input()
  service: PreservationPlanningMonitorService;

  @Input()
  index: number | undefined;

  constructor(private readonly _dialog: MatDialog) {
    super();
  }

  getResourceName(url: string): string {
    return url.substring(url.lastIndexOf(urlSeparator) + 1, url.length);
  }

  getResources(): HateOASLink[] {
    let resources = undefined;
    if (isNullOrUndefined(this.service._links)) {
      return resources;
    }
    resources = this.service._links.resources;
    if (isArray(resources)) {
      return resources;
    }
    return [resources];
  }

  open(apiUrl: string, serviceName: string, resourceName: string = undefined): void {
    this.subscribe(this._dialog.open(PreservationPlanningMonitoringWebServiceDialog, {
      data: {
        apiUrl: apiUrl,
        serviceName: serviceName,
        resourceName: resourceName,
      } as MonitoringWebServiceDialogData,
    }).afterClosed().pipe(
      take(1),
      tap((message: string | undefined) => {
        if (isNullOrUndefined(message)) {
          return;
        }
      }),
    ));
  }
}
