import {
  ChangeDetectionStrategy,
  Component,
  Inject,
  OnInit,
} from "@angular/core";
import {FormBuilder} from "@angular/forms";
import {
  MAT_DIALOG_DATA,
  MatDialogRef,
} from "@angular/material/dialog";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {PreservationPlanningMonitoringWebServiceAction} from "@preservation-planning/monitoring/stores/web-service/preservation-planning-monitoring-web-service.action";
import {PreservationPlanningMonitoringWebServiceState} from "@preservation-planning/monitoring/stores/web-service/preservation-planning-monitoring-web-service.state";
import {SharedAbstractContainer} from "@shared/components/containers/shared-abstract/shared-abstract.container";
import {Observable} from "rxjs";
import {
  isNullOrUndefined,
  MemoizedUtil,
  StringUtil,
} from "solidify-frontend";

@Component({
  selector: "dlcm-preservation-planning-monitoring-web-service-dialog",
  templateUrl: "./preservation-planning-monitoring-web-service.dialog.html",
  styleUrls: ["./preservation-planning-monitoring-web-service.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PreservationPlanningMonitoringWebServiceDialog extends SharedAbstractContainer implements OnInit {
  isLoadingObs: Observable<boolean> = MemoizedUtil.isLoading(this._store, PreservationPlanningMonitoringWebServiceState);
  resultObs: Observable<object> = MemoizedUtil.select(this._store, PreservationPlanningMonitoringWebServiceState, state => state.result);

  constructor(private readonly _store: Store,
              private readonly _actions$: Actions,
              private readonly _dialogRef: MatDialogRef<PreservationPlanningMonitoringWebServiceDialog>,
              @Inject(MAT_DIALOG_DATA) public data: MonitoringWebServiceDialogData,
              private readonly _fb: FormBuilder) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
    this._store.dispatch(new PreservationPlanningMonitoringWebServiceAction.Get(this.data.apiUrl));
  }

  getTitle(): string {
    return StringUtil.capitalize(this.data.serviceName) + (isNullOrUndefined(this.data.resourceName) ? "" : " > " + StringUtil.capitalize(this.data.resourceName));
  }
}

export interface MonitoringWebServiceDialogData {
  apiUrl: string;
  serviceName: string;
  resourceName: string | undefined;
}
