import {PreservationJob} from "@models";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {JobRecurrence} from "@shared/models/business/job-recurrence.model";
import {JobType} from "@shared/models/business/job-type.model";
import {
  BaseAction,
  BaseSubAction,
  ResourceAction,
  ResourceNameSpace,
  TypeDefaultAction,
} from "solidify-frontend";

const state = LocalStateEnum.preservationPlanning_job;

export namespace PreservationPlanningJobAction {
  @TypeDefaultAction(state)
  export class LoadResource extends ResourceAction.LoadResource {
  }

  @TypeDefaultAction(state)
  export class LoadResourceSuccess extends ResourceAction.LoadResourceSuccess {
  }

  @TypeDefaultAction(state)
  export class LoadResourceFail extends ResourceAction.LoadResourceFail {
  }

  @TypeDefaultAction(state)
  export class ChangeQueryParameters extends ResourceAction.ChangeQueryParameters {
  }

  @TypeDefaultAction(state)
  export class GetAll extends ResourceAction.GetAll {
  }

  @TypeDefaultAction(state)
  export class GetAllSuccess extends ResourceAction.GetAllSuccess<PreservationJob> {
  }

  @TypeDefaultAction(state)
  export class GetAllFail extends ResourceAction.GetAllFail<PreservationJob> {
  }

  @TypeDefaultAction(state)
  export class GetByListId extends ResourceAction.GetByListId {
  }

  @TypeDefaultAction(state)
  export class GetByListIdSuccess extends ResourceAction.GetByListIdSuccess {
  }

  @TypeDefaultAction(state)
  export class GetByListIdFail extends ResourceAction.GetByListIdFail {
  }

  @TypeDefaultAction(state)
  export class GetById extends ResourceAction.GetById {
  }

  @TypeDefaultAction(state)
  export class GetByIdSuccess extends ResourceAction.GetByIdSuccess<PreservationJob> {
  }

  @TypeDefaultAction(state)
  export class GetByIdFail extends ResourceAction.GetByIdFail<PreservationJob> {
  }

  @TypeDefaultAction(state)
  export class Create extends ResourceAction.Create<PreservationJob> {
  }

  @TypeDefaultAction(state)
  export class CreateSuccess extends ResourceAction.CreateSuccess<PreservationJob> {
  }

  @TypeDefaultAction(state)
  export class CreateFail extends ResourceAction.CreateFail<PreservationJob> {
  }

  @TypeDefaultAction(state)
  export class Update extends ResourceAction.Update<PreservationJob> {
  }

  @TypeDefaultAction(state)
  export class UpdateSuccess extends ResourceAction.UpdateSuccess<PreservationJob> {
  }

  @TypeDefaultAction(state)
  export class UpdateFail extends ResourceAction.UpdateFail<PreservationJob> {
  }

  @TypeDefaultAction(state)
  export class Delete extends ResourceAction.Delete {
  }

  @TypeDefaultAction(state)
  export class DeleteSuccess extends ResourceAction.DeleteSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteFail extends ResourceAction.DeleteFail {
  }

  @TypeDefaultAction(state)
  export class AddInList extends ResourceAction.AddInList<PreservationJob> {
  }

  @TypeDefaultAction(state)
  export class AddInListById extends ResourceAction.AddInListById {
  }

  @TypeDefaultAction(state)
  export class AddInListByIdSuccess extends ResourceAction.AddInListByIdSuccess<PreservationJob> {
  }

  @TypeDefaultAction(state)
  export class AddInListByIdFail extends ResourceAction.AddInListByIdFail<PreservationJob> {
  }

  @TypeDefaultAction(state)
  export class RemoveInListById extends ResourceAction.RemoveInListById {
  }

  @TypeDefaultAction(state)
  export class RemoveInListByListId extends ResourceAction.RemoveInListByListId {
  }

  @TypeDefaultAction(state)
  export class LoadNextChunkList extends ResourceAction.LoadNextChunkList {
  }

  @TypeDefaultAction(state)
  export class LoadNextChunkListSuccess extends ResourceAction.LoadNextChunkListSuccess<PreservationJob> {
  }

  @TypeDefaultAction(state)
  export class LoadNextChunkListFail extends ResourceAction.LoadNextChunkListFail {
  }

  @TypeDefaultAction(state)
  export class Clean extends ResourceAction.Clean {
  }

  export class Resume extends BaseAction {
    static readonly type: string = `[${state}] Resume`;

    constructor(public resId: string) {
      super();
    }
  }

  export class ResumeSuccess extends BaseSubAction<Resume> {
    static readonly type: string = `[${state}] Resume Success`;
  }

  export class ResumeFail extends BaseSubAction<Resume> {
    static readonly type: string = `[${state}] Resume Fail`;
  }

  export class Start extends BaseAction {
    static readonly type: string = `[${state}] Start`;

    constructor(public resId: string) {
      super();
    }
  }

  export class StartSuccess extends BaseSubAction<Start> {
    static readonly type: string = `[${state}] Start Success`;
  }

  export class StartFail extends BaseSubAction<Start> {
    static readonly type: string = `[${state}] Start Fail`;
  }

  export class VerifyBeforeStart extends BaseAction {
    static readonly type: string = `[${state}] Verify Before Start`;

    constructor(public resId: string) {
      super();
    }
  }

  export class VerifyBeforeStartSuccess extends BaseSubAction<VerifyBeforeStart> {
    static readonly type: string = `[${state}] Verify Before Start Success`;
  }

  export class VerifyBeforeStartFail extends BaseSubAction<VerifyBeforeStart> {
    static readonly type: string = `[${state}] Verify Start Fail`;
  }

  export class Init extends BaseAction {
    static readonly type: string = `[${state}] Init`;
  }

  export class InitSuccess extends BaseSubAction<Init> {
    static readonly type: string = `[${state}] Init Success`;
  }

  export class InitFail extends BaseSubAction<Init> {
    static readonly type: string = `[${state}] Init Fail`;
  }

  export class ListJobRecurrences extends BaseAction {
    static readonly type: string = `[${state}] List Job Recurrences`;
  }

  export class ListJobRecurrencesSuccess extends BaseSubAction<ListJobRecurrences> {
    static readonly type: string = `[${state}] List Job Recurrences Success`;

    constructor(public parent: ListJobRecurrences, public listJobRecurrences: JobRecurrence[]) {
      super(parent);
    }
  }

  export class ListJobRecurrencesFail extends BaseSubAction<ListJobRecurrences> {
    static readonly type: string = `[${state}] List Job Recurrences Fail`;
  }

  export class ListJobTypes extends BaseAction {
    static readonly type: string = `[${state}] List Job Types`;
  }

  export class ListJobTypesSuccess extends BaseSubAction<ListJobTypes> {
    static readonly type: string = `[${state}] List Job Types Success`;

    constructor(public parent: ListJobTypes, public listJobTypes: JobType[]) {
      super(parent);
    }
  }

  export class ListJobTypesFail extends BaseSubAction<ListJobTypes> {
    static readonly type: string = `[${state}] List Job Types Fail`;
  }
}

export const preservationPlanningJobActionNameSpace: ResourceNameSpace = PreservationPlanningJobAction;
