import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {JobExecutionReport} from "@shared/models/business/job-execution-report.model";
import {JobExecution} from "@shared/models/business/job-execution.model";
import {
  BaseAction,
  BaseSubAction,
  CollectionTyped,
  CompositionAction,
  CompositionNameSpace,
  TypeDefaultAction,
} from "solidify-frontend";

const state = LocalStateEnum.preservationPlanning_job_execution;

export namespace PreservationPlanningJobExecutionAction {
  @TypeDefaultAction(state)
  export class GetAll extends CompositionAction.GetAll {
  }

  @TypeDefaultAction(state)
  export class GetAllSuccess extends CompositionAction.GetAllSuccess<JobExecution> {
  }

  @TypeDefaultAction(state)
  export class GetAllFail extends CompositionAction.GetAllFail {
  }

  @TypeDefaultAction(state)
  export class GetById extends CompositionAction.GetById {
  }

  @TypeDefaultAction(state)
  export class GetByIdSuccess extends CompositionAction.GetByIdSuccess<JobExecution> {
  }

  @TypeDefaultAction(state)
  export class GetByIdFail extends CompositionAction.GetByIdFail {
  }

  @TypeDefaultAction(state)
  export class Update extends CompositionAction.Update<JobExecution> {
  }

  @TypeDefaultAction(state)
  export class UpdateSuccess extends CompositionAction.UpdateSuccess<JobExecution> {
  }

  @TypeDefaultAction(state)
  export class UpdateFail extends CompositionAction.UpdateFail<JobExecution> {
  }

  @TypeDefaultAction(state)
  export class Create extends CompositionAction.Create<JobExecution> {
  }

  @TypeDefaultAction(state)
  export class CreateSuccess extends CompositionAction.CreateSuccess<JobExecution> {
  }

  @TypeDefaultAction(state)
  export class CreateFail extends CompositionAction.CreateFail<JobExecution> {
  }

  @TypeDefaultAction(state)
  export class Delete extends CompositionAction.Delete {
  }

  @TypeDefaultAction(state)
  export class DeleteSuccess extends CompositionAction.DeleteSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteFail extends CompositionAction.DeleteFail {
  }

  @TypeDefaultAction(state)
  export class ChangeQueryParameters extends CompositionAction.ChangeQueryParameters {
  }

  export class Resume extends BaseAction {
    static readonly type: string = `[${state}] Resume`;

    constructor(public parentId: string, public jobExecutionId: string) {
      super();
    }
  }

  export class ResumeSuccess extends BaseSubAction<Resume> {
    static readonly type: string = `[${state}] Resume Success`;
  }

  export class ResumeFail extends BaseSubAction<Resume> {
    static readonly type: string = `[${state}] Resume Fail`;
  }

  export class GetListReport extends BaseAction {
    static readonly type: string = `[${state}] Get List Reports`;

    constructor(public parentId: string, public jobExecutionId: string) {
      super();
    }
  }

  export class GetListReportSuccess extends BaseSubAction<GetListReport> {
    static readonly type: string = `[${state}] Get List Report Success`;

    constructor(public parentAction: GetListReport, public list: CollectionTyped<JobExecutionReport>) {
      super(parentAction);
    }
  }

  export class GetListReportFail extends BaseSubAction<GetListReport> {
    static readonly type: string = `[${state}] Get List Report Fail`;
  }

}

export const preservationJobExecutionActionNameSpace: CompositionNameSpace = PreservationPlanningJobExecutionAction;
