import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {ReportNamespace} from "@preservation-planning/job/stores/job-execution/job-execution-report/preservation-planning-job-execution-report-namespace.model";
import {JobExecutionReportLine} from "@shared/models/business/job-execution-report-line.model";
import {JobExecutionReport} from "@shared/models/business/job-execution-report.model";
import {
  BaseAction,
  BaseSubAction,
  CollectionTyped,
  QueryParameters,
} from "solidify-frontend";

const state = LocalStateEnum.preservationPlanning_job_execution_report;

export namespace PreservationPlanningJobExecutionReportAction {

  export class GoToAip {
    static readonly type: string = `[${state}] Go To Aip`;

    constructor(public aipId: string) {
    }
  }

  export class GoToSip {
    static readonly type: string = `[${state}] Go To Sip`;

    constructor(public sipId: string) {
    }
  }

  export class GoToDeposit {
    static readonly type: string = `[${state}] Go To Deposit`;

    constructor(public depositId: string) {
    }
  }

  export class Report extends BaseAction {
    static readonly type: string = `[${state}] Report`;

    constructor(public id: string, public parentId: string, public queryParameters?: QueryParameters) {
      super();
    }
  }

  export class ReportSuccess extends BaseSubAction<Report> {
    static readonly type: string = `[${state}] Report Success`;

    constructor(public parentAction: Report, public list: CollectionTyped<JobExecutionReport>) {
      super(parentAction);
    }
  }

  export class ReportFail extends BaseSubAction<Report> {
    static readonly type: string = `[${state}] Report Fail`;
  }

  export class ChangeQueryParameters extends BaseAction {
    static readonly type: string = `[${state}] Change Query Parameter`;

    constructor(public queryParameters: QueryParameters, public id: string, public parentId?: string) {
      super();
    }
  }

  export class ReportLines extends BaseAction {
    static readonly type: string = `[${state}] Report Lines`;

    constructor(public id: string, public parentId: string, public reportId: string, public queryParameters?: QueryParameters) {
      super();
    }
  }

  export class ReportLinesSuccess extends BaseSubAction<ReportLines> {
    static readonly type: string = `[${state}] Report Lines Success`;

    constructor(public parentAction: ReportLines, public list: CollectionTyped<JobExecutionReportLine>) {
      super(parentAction);
    }
  }

  export class ReportLinesFail extends BaseSubAction<ReportLines> {
    static readonly type: string = `[${state}]] Report Lines Fail`;
  }

  export class ChangeQueryParametersLines extends BaseAction {
    static readonly type: string = `[${state}] Change Query Parameters Lines`;

    constructor(public queryParameters: QueryParameters, public id: string, public parentId: string, public reportId: string) {
      super();
    }
  }

  export class CleanQueryParametersLines extends BaseAction {
    static readonly type: string = `[${state}] Clean Query Parameters Lines`;

    constructor() {
      super();
    }
  }

  export class CleanQueryParameters extends BaseAction {
    static readonly type: string = `[${state}] Clean Query Parameters`;

    constructor() {
      super();
    }
  }
}

export const preservationPlanningJobExecutionReportNamespace: ReportNamespace = PreservationPlanningJobExecutionReportAction;
