import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {PreservationPlanningJobExecutionListContainer} from "@preservation-planning/job/components/containers/job-execution-list/preservation-planning-job-execution-list.container";
import {PreservationPlanningJobReportDetailErrorMessageDialog} from "@preservation-planning/job/components/dialogs/job-report-detail-error-message/preservation-planning-job-report-detail-error-message.dialog";
import {PreservationPlanningJobReportDetailDialog} from "@preservation-planning/job/components/dialogs/job-report-detail/preservation-planning-job-report-detail.dialog";
import {PreservationPlanningJobExecutionFormPresentational} from "@preservation-planning/job/components/presentationals/job-execution-form/preservation-planning-job-execution-form.presentational";
import {PreservationPlanningJobFormPresentational} from "@preservation-planning/job/components/presentationals/job-form/preservation-planning-job-form.presentational";
import {PreservationPlanningJobCreateRoutable} from "@preservation-planning/job/components/routables/job-create/preservation-planning-job-create.routable";
import {PreservationPlanningJobDetailEditRoutable} from "@preservation-planning/job/components/routables/job-detail-edit/preservation-planning-job-detail-edit.routable";
import {PreservationPlanningJobExecutionDetailRoutable} from "@preservation-planning/job/components/routables/job-execution-detail/preservation-planning-job-execution-detail.routable";
import {PreservationPlanningJobListRoutable} from "@preservation-planning/job/components/routables/job-list/preservation-planning-job-list.routable";
import {PreservationPlanningJobRoutingModule} from "@preservation-planning/job/preservation-planning-job-routing.module";
import {PreservationPlanningJobExecutionReportState} from "@preservation-planning/job/stores/job-execution/job-execution-report/preservation-planning-job-execution-report.state";
import {PreservationPlanningJobExecutionState} from "@preservation-planning/job/stores/job-execution/preservation-planning-job-execution.state";
import {PreservationPlanningJobState} from "@preservation-planning/job/stores/preservation-planning-job.state";

const routables = [
  PreservationPlanningJobListRoutable,
  PreservationPlanningJobDetailEditRoutable,
  PreservationPlanningJobCreateRoutable,
  PreservationPlanningJobExecutionDetailRoutable,
];
const containers = [
  PreservationPlanningJobExecutionListContainer,
];
const dialogs = [
  PreservationPlanningJobReportDetailDialog,
  PreservationPlanningJobReportDetailErrorMessageDialog,
];
const presentationals = [
  PreservationPlanningJobFormPresentational,
  PreservationPlanningJobExecutionFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    PreservationPlanningJobRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      PreservationPlanningJobState,
      PreservationPlanningJobExecutionState,
      PreservationPlanningJobExecutionReportState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class PreservationPlanningJobModule {
}
