import {NgModule} from "@angular/core";
import {RouterModule} from "@angular/router";
import {DlcmRoutes} from "@app/shared/models/dlcm-route.model";
import {PreservationPlanningJobCreateRoutable} from "@preservation-planning/job/components/routables/job-create/preservation-planning-job-create.routable";
import {PreservationPlanningJobDetailEditRoutable} from "@preservation-planning/job/components/routables/job-detail-edit/preservation-planning-job-detail-edit.routable";
import {PreservationPlanningJobExecutionDetailRoutable} from "@preservation-planning/job/components/routables/job-execution-detail/preservation-planning-job-execution-detail.routable";
import {PreservationPlanningJobListRoutable} from "@preservation-planning/job/components/routables/job-list/preservation-planning-job-list.routable";
import {PreservationPlanningJobState} from "@preservation-planning/job/stores/preservation-planning-job.state";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AppRoutesEnum,
  PreservationPlanningRoutesEnum,
} from "@shared/enums/routes.enum";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";

const routes: DlcmRoutes = [
  {
    path: AppRoutesEnum.root,
    component: PreservationPlanningJobListRoutable,
    data: {},
    children: [],
  },
  {
    path: PreservationPlanningRoutesEnum.jobCreate,
    component: PreservationPlanningJobCreateRoutable,
    data: {
      breadcrumb: LabelTranslateEnum.create,
    },
    canDeactivate: [CanDeactivateGuard],
  },
  {
    path: PreservationPlanningRoutesEnum.jobDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: PreservationPlanningJobDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: PreservationPlanningJobState.currentTitle,
    },
    children: [
      {
        path: PreservationPlanningRoutesEnum.execution + AppRoutesEnum.separator + AppRoutesEnum.paramIdExecution,
        component: PreservationPlanningJobExecutionDetailRoutable,
        data: {
          breadcrumb: LabelTranslateEnum.executions,
        },
      },
      {
        path: PreservationPlanningRoutesEnum.jobEdit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
        },
        canDeactivate: [CanDeactivateGuard],
      },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class PreservationPlanningJobRoutingModule {
}
