import {
  ChangeDetectorRef,
  Component,
  OnInit,
  ViewChild,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {
  ActivatedRoute,
  Router,
  RouterStateSnapshot,
} from "@angular/router";
import {Enums} from "@enums";
import {PreservationJob} from "@models";
import {
  Actions,
  ofActionCompleted,
  Select,
  Store,
} from "@ngxs/store";
import {PreservationPlanningJobExecutionListContainer} from "@preservation-planning/job/components/containers/job-execution-list/preservation-planning-job-execution-list.container";
import {PreservationPlanningJobExecutionState} from "@preservation-planning/job/stores/job-execution/preservation-planning-job-execution.state";
import {
  PreservationPlanningJobAction,
  preservationPlanningJobActionNameSpace,
} from "@preservation-planning/job/stores/preservation-planning-job.action";
import {
  PreservationPlanningJobState,
  PreservationPlanningJobStateModel,
} from "@preservation-planning/job/stores/preservation-planning-job.state";
import {SharedAbstractDetailEditCommonRoutable} from "@shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {PreservationPlanningRoutesEnum} from "@shared/enums/routes.enum";
import {JobExecution} from "@shared/models/business/job-execution.model";
import {JobRecurrence} from "@shared/models/business/job-recurrence.model";
import {ExtraButtonToolbar} from "@shared/models/extra-button-toolbar.model";
import {LocalStateModel} from "@shared/models/local-state.model";
import {ScrollService} from "@shared/services/scroll.service";
import {Observable} from "rxjs";
import {tap} from "rxjs/operators";
import {
  isNullOrUndefined,
  MemoizedUtil,
} from "solidify-frontend";
import JobRecurrenceEnum = JobRecurrence.JobRecurrenceEnum;

@Component({
  selector: "dlcm-preservation-planning-job-detail-edit-routable",
  templateUrl: "./preservation-planning-job-detail-edit.routable.html",
  styleUrls: ["./preservation-planning-job-detail-edit.routable.scss"],
})
export class PreservationPlanningJobDetailEditRoutable extends SharedAbstractDetailEditCommonRoutable<PreservationJob, PreservationPlanningJobStateModel> implements OnInit {
  @Select(PreservationPlanningJobState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(PreservationPlanningJobState.isReadyToBeDisplayed) isReadyToBeDisplayedObs: Observable<boolean>;
  @Select((state: LocalStateModel) => state.router.state) urlStateObs: Observable<RouterStateSnapshot>;

  listObs: Observable<JobExecution[]> = MemoizedUtil.list(this._store, PreservationPlanningJobExecutionState);

  @ViewChild("jobExecutionList")
  readonly jobExecutionList: PreservationPlanningJobExecutionListContainer;

  readonly KEY_PARAM_NAME: keyof PreservationJob & string = "name";
  preservationJob: boolean | undefined = undefined;

  listExtraButtons: ExtraButtonToolbar<PreservationJob>[] = [
    {
      color: "primary",
      icon: IconNameEnum.run,
      labelToTranslate: (current) => LabelTranslateEnum.run,
      callback: () => this.jobExecutionList.start(),
      displayCondition: (resource) => !this.isEdit && resource && (resource.jobRecurrence !== JobRecurrenceEnum.ONCE || MemoizedUtil.select(this._store, PreservationPlanningJobExecutionState, state => !isNullOrUndefined(state.list) && state.list.length === 0)),
      order: 41,
    },
    {
      color: "primary",
      icon: IconNameEnum.resume,
      labelToTranslate: (current) => LabelTranslateEnum.resume,
      callback: () => this.jobExecutionList.resume(),
      displayCondition: (resource) => !this.isEdit && resource && (resource.lastExecutionStatus === Enums.PreservationJob.ExecutionStatusEnum.IN_ERROR),
      order: 41,
    },
  ];

  constructor(protected _store: Store,
              protected _route: ActivatedRoute,
              protected _router: Router,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              public _dialog: MatDialog,
              private readonly _scrollService: ScrollService) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.preservationPlanning_job, preservationPlanningJobActionNameSpace, LocalStateEnum.preservationPlanning);
  }

  getSubResourceWithParentId(id: string): void {
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.subscribe(this.urlStateObs
      .pipe(
        tap(urlState => {
          if (urlState) {
            const url = urlState.url;
            this.preservationJob = !url.includes(PreservationPlanningRoutesEnum.execution);
          }
        }),
      ));
  }

  start(): void {
    this._store.dispatch(new PreservationPlanningJobAction.VerifyBeforeStart(this._resId));
    this.subscribe(this._actions$.pipe(ofActionCompleted(PreservationPlanningJobAction.StartSuccess)),
      result => {
        if (result.result.successful === true) {
          this.jobExecutionList.getAll();
        }
      });
  }

  refresh(): void {
    this.jobExecutionList.getAll();
  }
}
