import {
  ChangeDetectorRef,
  Component,
  ViewChild,
} from "@angular/core";
import {preservationPlanningJobActionNameSpace} from "@preservation-planning/job/stores/preservation-planning-job.action";
import {
  PreservationPlanningJobState,
  PreservationPlanningJobStateModel,
} from "@preservation-planning/job/stores/preservation-planning-job.state";
import {PreservationJob} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Observable} from "rxjs";

@Component({
  selector: "dlcm-preservation-planning-job-create-routable",
  templateUrl: "./preservation-planning-job-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
})
export class PreservationPlanningJobCreateRoutable extends SharedAbstractCreateRoutable<PreservationJob, PreservationPlanningJobStateModel> {
  @Select(PreservationPlanningJobState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(PreservationPlanningJobState.isReadyToBeDisplayedInCreateMode) isReadyToBeDisplayedInCreateModeObs: Observable<boolean>;

  @ViewChild("formPresentational")
  readonly formPresentational: SharedAbstractFormPresentational<PreservationJob>;

  constructor(protected readonly _store: Store,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super(_store, _actions$, _changeDetector, LocalStateEnum.preservationPlanning_job, preservationPlanningJobActionNameSpace, LocalStateEnum.preservationPlanning);
  }
}
