import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ElementRef,
} from "@angular/core";
import {
  FormBuilder,
  Validators,
} from "@angular/forms";
import {Enums} from "@enums";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {JobExecution} from "@shared/models/business/job-execution.model";
import {
  DateUtil,
  KeyValue,
  PropertyName,
  SolidifyValidator,
} from "solidify-frontend";

@Component({
  selector: "dlcm-preservation-planning-job-execution-form",
  templateUrl: "./preservation-planning-job-execution-form.presentational.html",
  styleUrls: ["../../../../../../shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class PreservationPlanningJobExecutionFormPresentational extends SharedAbstractFormPresentational<JobExecution> {
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  listExecutionStatusToTranslate: KeyValue[] = Enums.PreservationJob.ExecutionStatusEnumTranslate;

  constructor(protected readonly _changeDetectorRef: ChangeDetectorRef,
              protected readonly _elementRef: ElementRef,
              private readonly _fb: FormBuilder) {
    super(_changeDetectorRef, _elementRef);
  }

  protected bindFormTo(jobExecution: JobExecution): void {
    this.form = this._fb.group({
      [this.formDefinition.status]: [jobExecution.status, [Validators.required, SolidifyValidator]],
      [this.formDefinition.statusMessage]: [jobExecution.statusMessage, [SolidifyValidator]],
      [this.formDefinition.startDate]: [DateUtil.convertDateToDateTimeString(jobExecution.startDate), [Validators.required, SolidifyValidator]],
      [this.formDefinition.endDate]: [DateUtil.convertDateToDateTimeString(jobExecution.endDate), [Validators.required, SolidifyValidator]],
      [this.formDefinition.totalItems]: [jobExecution.ignoredItems + jobExecution.processedItems + jobExecution.inErrorItems, [Validators.required, SolidifyValidator]],
      [this.formDefinition.ignoredItems]: [jobExecution.ignoredItems, [Validators.required, SolidifyValidator]],
      [this.formDefinition.processedItems]: [jobExecution.processedItems, [Validators.required, SolidifyValidator]],
      [this.formDefinition.inErrorItems]: [jobExecution.inErrorItems, [Validators.required, SolidifyValidator]],
    });
  }

  protected initNewForm(): void {
    this.form = this._fb.group({
      [this.formDefinition.status]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.statusMessage]: ["", [SolidifyValidator]],
      [this.formDefinition.startDate]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.endDate]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.totalItems]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.ignoredItems]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.processedItems]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.inErrorItems]: ["", [Validators.required, SolidifyValidator]],
    });
  }

  protected treatmentBeforeSubmit(model: JobExecution): JobExecution {
    return undefined;
  }

}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() status: string;
  @PropertyName() statusMessage: string;
  @PropertyName() startDate: string;
  @PropertyName() endDate: string;
  @PropertyName() totalItems: string;
  @PropertyName() ignoredItems: string;
  @PropertyName() processedItems: string;
  @PropertyName() inErrorItems: string;
}
