import {
  Component,
  Inject,
  OnInit,
} from "@angular/core";
import {
  MAT_DIALOG_DATA,
  MatDialogRef,
} from "@angular/material/dialog";
import {SharedAbstractContainer} from "@shared/components/containers/shared-abstract/shared-abstract.container";
import {MARK_AS_TRANSLATABLE, StringUtil} from "solidify-frontend";

@Component({
  selector: "dlcm-preservation-planning-job-report-detail-error-message-dialog",
  templateUrl: "./preservation-planning-job-report-detail-error-message.dialog.html",
})
export class PreservationPlanningJobReportDetailErrorMessageDialog extends SharedAbstractContainer implements OnInit {
  public readonly KEY_TITLE: string = MARK_AS_TRANSLATABLE("preservation.jobExecution.report.detail.errorMessage.title");

  paramMessage: { resId: string } = {resId: StringUtil.stringEmpty};

  constructor(protected readonly _dialogRef: MatDialogRef<PreservationPlanningJobReportDetailErrorMessageDialog>,
              @Inject(MAT_DIALOG_DATA) public data: ErrorMessageWrapper) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.paramMessage = {resId: this.data.resId};
  }
}

export interface ErrorMessageWrapper {
  errorMessage: string;
  resId: string;
}
