import {Injectable} from "@angular/core";
import {preservationPlanningDipStatusHistoryNamespace} from "@preservation-planning/dip/stores/status-history/preservation-planning-dip-status-history.action";
import {AccessResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {Dip} from "@models";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {
  defaultStatusHistoryInitValue,
  StatusHistoryState,
  StatusHistoryStateModel,
} from "@shared/stores/status-history/status-history.state";
import {
  ApiService,
  NotificationService,
} from "solidify-frontend";

export interface PreservationPlanningDipStatusHistoryStateModel extends StatusHistoryStateModel<Dip> {
}

@Injectable()
@State<PreservationPlanningDipStatusHistoryStateModel>({
  name: LocalStateEnum.preservationPlanning_dip_statusHistory,
  defaults: {
    ...defaultStatusHistoryInitValue(),
  },
})
export class PreservationPlanningDipStatusHistoryState extends StatusHistoryState<PreservationPlanningDipStatusHistoryStateModel, Dip> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: preservationPlanningDipStatusHistoryNamespace,
    });
  }

  protected get _urlResource(): string {
    return AccessResourceApiEnum.dip;
  }
}
